# delimit ;  
drop _all;
program drop _all;
clear all;
capture log close;
set more 1 ;  
local UNIX 0;
set maxvar 32000;
set mem 800m;
* set this to 1 if include 2020 wave;
global INCLUDE2020 0;

global folder "D:\Dropbox";
*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "C:\Users\Ali\Documents";
*global folder "C:\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\Users\ebf26\Dropbox\";

         local inspurchased  "$folder\ins_purchase\data\";
		 local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";
		 local rand   "$folder\hrs\rand\";
		 
drop _all;
program drop _all;
log using "`saved'randcode.log", replace ;


*use "`rand'rndhrs_d2.dta";
*sort hhidpn;
*compress;
*save "`rand'rndhrs_c.dta", replace;
*drop _all;


* OOP variables, code added by Chris Nov 2022 SEGMENT START;
use "`rand'randhrsimp1992_2018v2";
keep hhidpn r*mhosp r*mnhm r*mops r*mdr r*mdent r*mdrug r*mhhc r*mothx s*mhosp s*mnhm s*mops s*mdr s*mdent s*mdrug s*mhhc s*mothx;

program define oopgen;
        version 3.1;
        local i=1;
	while `i'<=14 {;
	
	if `i'>=6 { ;
	gen rhospc`i'= r`i'mhosp/2; *imputed oop hospital costs;
	gen rnursc`i'=r`i'mnhm/2; *imputed oop nursing home costs;
	gen routsgc`i'=r`i'mops/2; *imputed oop outpatient surgery costs;
	gen rdocc`i'=r`i'mdr/2; *imputed oop doctor visits costs;
	gen rdentc`i'=r`i'mdent/2; *imputed oop dental costs;
	gen rdrugc`i'=r`i'mdrug/2; *imputed oop rx drug costs;
	gen rhhsc`i'=r`i'mhhc/2; *imputed oop home health service costs;
	
	* spouse equivalents ;
	gen shospc`i'= s`i'mhosp/2; *imputed oop hospital costs;
	gen snursc`i'=s`i'mnhm/2; *imputed oop nursing home costs;
	gen soutsgc`i'=s`i'mops/2; *imputed oop outpatient surgery costs;
	gen sdocc`i'=s`i'mdr/2; *imputed oop doctor visits costs;
	gen sdentc`i'=s`i'mdent/2; *imputed oop dental costs;
	gen sdrugc`i'=s`i'mdrug/2; *imputed oop rx drug costs;
	gen shhsc`i'=s`i'mhhc/2; *imputed oop home health service costs;
	};
	
	if `i'>=10 { ;
		gen rothels`i'=r`i'mothx/2; *imputed oop amt. other health services;
		gen sothels`i'=s`i'mothx/2; *imputed oop amt. other health services;
	};
	if `i'<10 { ;
		gen rothels`i'=.; 
		gen sothels`i'=.; 
	};
	
	if `i'<6 { ;
	gen rhospc`i'= .;
	gen rnursc`i'=.;
	gen routsgc`i'=.;
	gen rdocc`i'=.;
	gen rdentc`i'=.;
	gen rdrugc`i'=.;
	gen rhhsc`i'=.;
	gen shospc`i'= .;
	gen snursc`i'=.;
	gen soutsgc`i'=.;
	gen sdocc`i'=.;
	gen sdentc`i'=.;
	gen sdrugc`i'=.;
	gen shhsc`i'=.;
	};
	
	local i=`i'+1};
		
end;

oopgen;
drop r*mhosp r*mnhm r*mops r*mdr r*mdent r*mdrug r*mhhc r*mothx s*mhosp s*mnhm s*mops s*mdr s*mdent s*mdrug s*mhhc s*mothx;
save "`saved'tempOOP", replace;
* OOP variables, code added by Chris Nov 2022 SEGMENT END;
***********************************************************************************************************************************;
* New code for Kang et al replication. Chris Dec 2022 ;
***********************************************************************************************************************************;
use "`wave2d'W2MOD5";
* logic from Fang vargen_hrs2000.do;
gen riskcatw2=1 if W9347==5;
replace riskcatw2=2 if W9347==1 & W9346==5;
replace riskcatw2=3 if W9346==1 & W9344==5;
replace riskcatw2=4 if W9344==1 & W9345==5;
replace riskcatw2=5 if W9345==1 & W9348==5;
replace riskcatw2=6 if W9348==1;
gen long hhidpn=real(HHID)*1000+real(PN);
sort hhidpn;
keep hhidpn riskcatw2;
save "`saved'temprisktol", replace;

use "`saved'huswife1";
save "`saved'temp", replace;

* drop hhidpn;
gen long hhidpn=HHID;
replace hhidpn=hhidpn*1000+PN;

sort hhidpn;
merge 1:1 hhidpn using "`rand'rndhrs_2018_small";

tab _merge;
drop if _merge==1;  
* this drops observations that are in my coding of the HRS, but not the RAND coding of the HRS;
* they appear to only be for cases where there was an individual who never responded to any questions;
*exit;
* OOP variables, code added by Chris Nov 2022 SEGMENT START;
merge 1:1 hhidpn using "`saved'tempOOP",generate(_mergeOOP);
tab _mergeOOP;
* OOP variables, code added by Chris Nov 2022 SEGMENT END;

merge 1:1 hhidpn using "`saved'temprisktol",generate(_mergerisktol);
tab _mergerisktol;

* Kimball risktol mapping as used by Fang et al;
* this code is copied straight from Fang's source code;
gen riskcatw1=5-r1risk;
gen risktolFSK=0.15 if riskcatw1==1 & riskcatw2==.;
replace risktolFSK=0.279 if riskcatw1==2 & riskcatw2==.;
replace risktolFSK=0.352 if riskcatw1==3 & riskcatw2==.;
replace risktolFSK=0.568 if riskcatw1==4 & riskcatw2==.;

replace risktolFSK=0.127 if riskcatw1==. & riskcatw2==1;
replace risktolFSK=0.221 if riskcatw1==. & riskcatw2==2;
replace risktolFSK=0.279 if riskcatw1==. & riskcatw2==3;
replace risktolFSK=0.352 if riskcatw1==. & riskcatw2==4;
replace risktolFSK=0.482 if riskcatw1==. & riskcatw2==5;
replace risktolFSK=0.802 if riskcatw1==. & riskcatw2==6;

replace risktolFSK=0.099 if riskcatw1==1 & riskcatw2==1;
replace risktolFSK=0.162 if riskcatw1==1 & riskcatw2==2;
replace risktolFSK=0.197 if riskcatw1==1 & riskcatw2==3;
replace risktolFSK=0.238 if riskcatw1==1 & riskcatw2==4;
replace risktolFSK=0.306 if riskcatw1==1 & riskcatw2==5;
replace risktolFSK=0.450 if riskcatw1==1 & riskcatw2==6;

replace risktolFSK=0.173 if riskcatw1==2 & riskcatw2==1;
replace risktolFSK=0.252 if riskcatw1==2 & riskcatw2==2;
replace risktolFSK=0.299 if riskcatw1==2 & riskcatw2==3;
replace risktolFSK=0.355 if riskcatw1==2 & riskcatw2==4;
replace risktolFSK=0.447 if riskcatw1==2 & riskcatw2==5;
replace risktolFSK=0.644 if riskcatw1==2 & riskcatw2==6;

replace risktolFSK=0.209 if riskcatw1==3 & riskcatw2==1;
replace risktolFSK=0.299 if riskcatw1==3 & riskcatw2==2;
replace risktolFSK=0.355 if riskcatw1==3 & riskcatw2==3;
replace risktolFSK=0.422 if riskcatw1==3 & riskcatw2==4;
replace risktolFSK=0.533 if riskcatw1==3 & riskcatw2==5;
replace risktolFSK=0.773 if riskcatw1==3 & riskcatw2==6;

replace risktolFSK=0.291 if riskcatw1==4 & riskcatw2==1;
replace risktolFSK=0.415 if riskcatw1==4 & riskcatw2==2;
replace risktolFSK=0.499 if riskcatw1==4 & riskcatw2==3;
replace risktolFSK=0.601 if riskcatw1==4 & riskcatw2==4;
replace risktolFSK=0.778 if riskcatw1==4 & riskcatw2==5;
replace risktolFSK=1.203 if riskcatw1==4 & riskcatw2==6;


* Kimball extended risktol mapping, so we use that as well ;
* first two variables are same as the shorter mapping used above;
gen c92=riskcatw1;
gen c94=riskcatw2;
gen c98=7-r4risk6;
gen c00=7-r5risk6;
gen c02=7-r6risk6;
summ c92 c94 c98 c00 c02;
* Kimball counts missing as zero, so do that;
replace c92=0 if c92>=.;
replace c94=0 if c94>=.;
replace c98=0 if c98>=.;
replace c00=0 if c00>=.;
replace c02=0 if c02>=.;


merge m:1 c92 c94 c98 c00 c02 using "`inspurchased'ProxyHRS",generate(_mergekimball);
tab _mergekimball;
drop _mergekimball;
* check against Kimball's ProxyHRS.out. All looks good;
*list hhidpn c92 c94 c98 c00 c02 risktol risktolFSK in 1/100;
*list c92 c94 c98 c00 c02 risktol risktolFSK if hhidpn==98802040 |  hhidpn==98859020 |  hhidpn==98859030 |  hhidpn==99231010 |  hhidpn==99564010 |  hhidpn==99587010;
*twoway (hist risktolFSK, frac lcolor(none) fcolor(green%20)) (hist risktol_enhanced, frac fcolor(red%30) lcolor(none)), legend(order(1 "risktolFSK" 2 "risktol_enhanced" ));



merge 1:1 hhidpn using "`inspurchased'numeracy",generate(_numeracy);
tab _numeracy;
drop _numeracy;
* not available before wave 6;
gen cog_numeracy1=.;
gen cog_numeracy2=.;
gen cog_numeracy3=.;
gen cog_numeracy4=.;
gen cog_numeracy5=.;
/*
summary from Fang_et_al_replication_files\codes-logs\codedhrs_merge.dta
. sum cog_recalim if year==2000  (wave 5)
    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
 cog_recalim |     17,345    5.470856    1.815484          0         10

. sum cog_recalim if year==2002  (wave 6)

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
 cog_recalim |     15,789    5.484325    1.741776          0         10
 
 RAND
 summ r5imrc  r6imrc

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
      r5imrc |     17,516    5.467915    1.815702          0         10
      r6imrc |     16,129    5.473495    1.764307          0         10
	  
	  
. sum cog_numeracy if year==2000

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
cog_numeracy |          0

. sum cog_numeracy if year==2002

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
cog_numeracy |     14,467    1.090344    .7904676          0          3

. sum risktol if year==2000

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
     risktol |      9,033    .2402453    .1463392       .099      1.203

. sum risktol if year==2002

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
     risktol |          0

from codedhrs_merge.dta
list  rahhidpn year risktol cog_numeracy cog_recalim  in 1/20

     +-----------------------------------------------------+
     |  rahhidpn   year   risktol cog_numeracy cog_recalim |
     |-----------------------------------------------------|
  1. | 000002010   2000      .279          .          5    |
  2. | 000003010   2002         .          1          9    |
  3. | 000003010   2000       .15          .         10    |
  4. | 000003020   2002         .          .          6    |
  5. | 000003020   2000       .15          .          6    |
     |-----------------------------------------------------|


this is a strange panel structure!	it's pooled but often has no intersection e.g.
reg risktol cog_numeracy
no observations

*/
drop r*fimrc;
rename r*imrc cog_recalim*;
gen cog_recalim1=.;
gen cog_recalim2=.;

gen cog_ticscore1=.;
gen cog_ticscore2=.;
gen cog_ticscore3=.;
gen cog_ticscore4=.;
gen cog_ticscore5 = r5bwc20 + r5dy+ r5mo+ r5yr+ r5dw+ r5cact +r5scis +r5pres +r5vp;
gen cog_ticscore6 = r6bwc20 + r6dy+ r6mo+ r6yr+ r6dw+ r6cact +r6scis +r6pres +r6vp;
gen cog_ticscore7 = r7bwc20 + r7dy+ r7mo+ r7yr+ r7dw+ r7cact +r7scis +r7pres +r7vp;
gen cog_ticscore8 = r8bwc20 + r8dy+ r8mo+ r8yr+ r8dw+ r8cact +r8scis +r8pres +r8vp;
gen cog_ticscore9 = r9bwc20 + r9dy+ r9mo+ r9yr+ r9dw+ r9cact +r9scis +r9pres +r9vp;
gen cog_ticscore10 = r10bwc20 + r10dy+ r10mo+ r10yr+ r10dw+ r10cact +r10scis +r10pres +r10vp;
gen cog_ticscore11 = r11bwc20 + r11dy+ r11mo+ r11yr+ r11dw+ r11cact +r11scis +r11pres +r11vp;
gen cog_ticscore12 = r12bwc20 + r12dy+ r12mo+ r12yr+ r12dw+ r12cact +r12scis +r12pres +r12vp;
gen cog_ticscore13 = r13bwc20 + r13dy+ r13mo+ r13yr+ r13dw+ r13cact +r13scis +r13pres +r13vp;
gen cog_ticscore14 = r14bwc20 + r14dy+ r14mo+ r14yr+ r14dw+ r14cact +r14scis +r14pres +r14vp;


drop r*fser7;
rename r*ser7 cog_subseven*;
gen cog_subseven1=.;
/* Note a slight diff in method.
Rand do "Correct subtractions are based on the prior number given, so that even if one subtraction
is incorrect subsequent trials are evaluated on the given (perhaps wrong) answer."
whereas Fang et al didn't allow for prior mistakes
*/

*RAND Imputed Cognition total mental status summary score;
rename 	r*mstot cog_mental_status*;
drop cog_mental_status2a;
gen cog_mental_status1=.;
gen cog_mental_status2=.;

* Most recent answer to the question "What is the chance you will live to 75 or more?" ;
* this praliv75 coding is taken from Fang but results used just for comparison;

gen praliv75_FSKmr5=r5liv75 if r5liv75<=100;
replace praliv75_FSKmr5=r4liv75 if praliv75_FSKmr5==. & r4liv75<=100;
replace praliv75_FSKmr5=r3liv75 if praliv75_FSKmr5==. & r3liv75<=100;
replace praliv75_FSKmr5=r2liv75 if praliv75_FSKmr5==. & r2liv75<=100;
replace praliv75_FSKmr5=r1liv75 if praliv75_FSKmr5==. & r1liv75<=100;

gen  praliv75_FSKmr6=r6liv75 if r6liv75<=100;
replace praliv75_FSKmr6=r5liv75 if praliv75_FSKmr6==. & r5liv75<=100;
replace praliv75_FSKmr6=r4liv75 if praliv75_FSKmr6==. & r4liv75<=100;
replace praliv75_FSKmr6=r3liv75 if praliv75_FSKmr6==. & r3liv75<=100;
replace praliv75_FSKmr6=r2liv75 if praliv75_FSKmr6==. & r2liv75<=100;
replace praliv75_FSKmr6=r1liv75 if praliv75_FSKmr6==. & r1liv75<=100;

gen praliv75_FSKaltmr6=r6liv75 if r6liv75<=100;
replace praliv75_FSKaltmr6=praliv75_FSKmr5 if praliv75_FSKaltmr6==. ;

rename r*liv75 praliv75_mr*;	
local wc = 1;
while `wc' <= 14 {;
  * follow FSK logic on 100  ;
	replace  praliv75_mr`wc'=. if praliv75_mr`wc'>100;
	local wc=`wc'+1;
};


rename r*liv10 praliv10_mr*;	
gen praliv10_mr1=.;
gen praliv10_mr4=.;

local wc = 1;
while `wc' <= 14 {;
* non existent wave variables 2,3 and 9,10;
if `wc'==2 | `wc'==3 | `wc'==9 | `wc'==10 {;
gen fnpln_gtten`wc'=.;
gen fnpln_fivetoten`wc'=.;
gen fnpln_three`wc'=.;
gen fnpln_one`wc'=.;
gen fnpln_fewmo`wc'=.;
 };
else {;
	gen fnpln_gtten`wc'=1 if r`wc'finpln==5;
* FSK logic doesn't account for other missing values such as .a etc
*	replace fnpln_gtten`wc'=0 if r`wc'finpln<5;
* replace fnpln_gtten`wc'=0 if r`wc'finpln~=5  & r`wc'finpln~=.;

replace fnpln_gtten`wc'=0 if r`wc'finpln<5;
gen fnpln_fivetoten`wc'=1 if r`wc'finpln==4;
replace fnpln_fivetoten`wc'=0 if inlist(r`wc'finpln, 1, 2, 3, 5);
gen fnpln_three`wc'=1 if r`wc'finpln==3;
replace fnpln_three`wc'=0 if inlist(r`wc'finpln, 1, 2, 4, 5);
gen fnpln_one`wc'=1 if r`wc'finpln==2;
replace fnpln_one`wc'=0 if  inlist(r`wc'finpln, 1, 3, 4, 5);
gen fnpln_fewmo`wc'=1 if r`wc'finpln==1; 
replace fnpln_fewmo`wc'=0 if inlist(r`wc'finpln, 2, 3, 4, 5);
};

local wc=`wc'+1;
};

* all the extra variables for Table 6 regressions ;
summ fnpln* praliv10_mr* praliv75_mr* cog_mental_status* cog_subseven* cog_recalim* cog_numeracy* cog_ticscore* risktol*; 



********************************************************************************************************************************************** ;
* code to make all variables "most recent" ;
* at this point we have variables for each wave e.g. cog_recalim5, cog_recalim56, cog_recalim7 etc
* Note, for example, cog_recalim5 corresponds to FSK cog_recalim for year==2000
* set the variables so that wave i uses its own observations, or from wave i-1 if no observation is made at i  ;
* risktol is time-invariant, and imputed once for a particular subset of individuals, per Kimball's analysis ; 
* all the other variables are a mix of "current" observations and "past";
********************************************************************************************************************************************** ;

gen risktolFSK1=risktolFSK;
gen risktol_enhanced1=risktol_enhanced;
local wc = 2;
local wc_l1 = 1;
* only need up to wave 11 for the FSK replication but do 14 anyway;
while `wc' <= 14 {;

replace  fnpln_gtten`wc'=fnpln_gtten`wc_l1' if fnpln_gtten`wc'>=.;
replace  fnpln_fivetoten`wc'=fnpln_fivetoten`wc_l1' if fnpln_fivetoten`wc'>=.;
replace  fnpln_three`wc'=fnpln_three`wc_l1' if fnpln_three`wc'>=.;
replace  fnpln_one`wc'=fnpln_one`wc_l1' if fnpln_one`wc'>=.;
replace  fnpln_fewmo`wc'=fnpln_fewmo`wc_l1' if fnpln_fewmo`wc'>=.;

replace  praliv75_mr`wc'=praliv75_mr`wc_l1' if praliv75_mr`wc'>=.;
replace  praliv10_mr`wc'=praliv10_mr`wc_l1' if praliv10_mr`wc'>=.;

replace  cog_mental_status`wc'=cog_mental_status`wc_l1' if cog_mental_status`wc'>=.;
replace  cog_subseven`wc'=cog_subseven`wc_l1' if cog_subseven`wc'>=.;
replace  cog_recalim`wc'=cog_recalim`wc_l1' if cog_recalim`wc'>=.;
replace  cog_ticscore`wc'=cog_ticscore`wc_l1' if cog_ticscore`wc'>=.;
replace  cog_numeracy`wc'=cog_numeracy`wc_l1' if cog_numeracy`wc'>=.;

********* ; 
gen risktolFSK`wc'=risktolFSK;
gen risktol_enhanced`wc'=risktol_enhanced;
 
local wc=`wc'+1;
local wc_l1=`wc_l1'+1;
};

summ praliv75_FSKmr5 praliv75_FSKmr5 praliv75_FSKaltmr6;
summ praliv75_mr5 praliv75_mr6;
drop risktolFSK risktol_enhanced praliv75_FSKmr5 praliv75_FSKmr5 praliv75_FSKaltmr6;
summ fnpln* praliv10_mr* praliv75_mr* cog_mental_status* cog_subseven* cog_recalim* cog_numeracy* cog_ticscore* risktol*; 

* Jan 2023 add vriables for FSK Tables 1 and 2 ;
*  mainly health, ADLs, edu, race              ;

local wc = 1;
while `wc' <= 14 {;

**************************************************;
* Highest Grade Completed                         ;
* Omitted category is zero schooling              ;
**************************************************;

gen hgc_ls8th`wc'=1 if raedyrs>0 & raedyrs<=8;
replace hgc_ls8th`wc'=0 if hgc_ls8th`wc'==.;

gen hgc_somehs`wc'=1 if raedyrs>8 & raedyrs<=11;
replace hgc_somehs`wc'=0 if hgc_somehs`wc'==.;

gen hgc_hs`wc'=1 if raedyrs==12;
replace hgc_hs`wc'=0 if hgc_hs`wc'==.;

gen hgc_somecol`wc'=1 if raedyrs>12 & raedyrs<16;
replace hgc_somecol`wc'=0 if hgc_somecol`wc'==.;

gen hgc_college`wc'=1 if raedyrs==16;
replace hgc_college`wc'=0 if hgc_college`wc'==.;

gen hgc_gradschl`wc'=1 if raedyrs>16 & raedyrs<97;
replace hgc_gradschl`wc'=0 if hgc_gradschl`wc'==.;

gen hgc_nr`wc'=1 if raedyrs>=97;
replace hgc_nr`wc'=0 if hgc_nr`wc'==.;


****************************************************;
* using the RAND income imputations                 ;
****************************************************;
gen incwi_5k_10k`wc'=1 if h`wc'itot>5000 & h`wc'itot<=10000;
replace incwi_5k_10k`wc'=0 if incwi_5k_10k`wc'==. & h`wc'itot~=.;

gen incwi_10k_15k`wc'=1 if h`wc'itot>10000 & h`wc'itot<=15000;
replace incwi_10k_15k`wc'=0 if incwi_10k_15k`wc'==. & h`wc'itot~=.;

gen incwi_15k_20k`wc'=1 if h`wc'itot>15000 & h`wc'itot<=20000;
replace incwi_15k_20k`wc'=0 if incwi_15k_20k`wc'==. & h`wc'itot~=.;

gen incwi_20k_25k`wc'=1 if h`wc'itot>20000 & h`wc'itot<=25000;
replace incwi_20k_25k`wc'=0 if incwi_20k_25k`wc'==. & h`wc'itot~=.;

gen incwi_25k_30k`wc'=1 if h`wc'itot>25000 & h`wc'itot<=30000;
replace incwi_25k_30k`wc'=0 if incwi_25k_30k`wc'==. & h`wc'itot~=.;

gen incwi_30k_35k`wc'=1 if h`wc'itot>30000 & h`wc'itot<=35000;
replace incwi_30k_35k`wc'=0 if incwi_30k_35k`wc'==. & h`wc'itot~=.;

gen incwi_35k_40k`wc'=1 if h`wc'itot>35000 & h`wc'itot<=40000;
replace incwi_35k_40k`wc'=0 if incwi_35k_40k`wc'==. & h`wc'itot~=.;

gen incwi_40k_45k`wc'=1 if h`wc'itot>40000 & h`wc'itot<=45000;
replace incwi_40k_45k`wc'=0 if incwi_40k_45k`wc'==. & h`wc'itot~=.;

gen incwi_45k_50k`wc'=1 if h`wc'itot>45000 & h`wc'itot<=50000;
replace incwi_45k_50k`wc'=0 if incwi_45k_50k`wc'==. & h`wc'itot~=.;

gen incwi_50plus`wc'=1 if h`wc'itot>50000 & h`wc'itot~=.;
replace incwi_50plus`wc'=0 if incwi_50plus`wc'==. & h`wc'itot~=.;

* Self-reported health               ;
* Omitted category is "poor" health  ;
*************************************;
gen srphlth_nr`wc'=1 if r`wc'shlt>5 & r`wc'shlt~=.;
replace srphlth_nr`wc'=0 if r`wc'shlt<=5;

gen srphlth_ex`wc'=1 if r`wc'shlt==1;
replace srphlth_ex`wc'=0 if srphlth_nr`wc'~=. & r`wc'shlt~=1;

gen srphlth_vgood`wc'=1 if r`wc'shlt==2;
replace srphlth_vgood`wc'=0 if srphlth_nr`wc'~=. & r`wc'shlt~=2;

gen srphlth_good`wc'=1 if r`wc'shlt==3;
replace srphlth_good`wc'=0 if srphlth_nr`wc'~=. & r`wc'shlt~=3;

gen srphlth_fair`wc'=1 if r`wc'shlt==4;
replace srphlth_fair`wc'=0 if srphlth_nr`wc'~=. & r`wc'shlt~=4;

*if `wc'>=7 {;
* 5 category response not available from wave 7 so use 3 category throughout;
* r`wc'hltc3 is a 3 category variable ;
* 1.Better  ;
* 2.About the same  ;
* 3.Worse;
* Omitted category is worse;
**********************************;
*gen dsrphlth_mbetter`wc'=.;
*gen dsrphlth_sworse`wc'=.;

gen dsrphlth_nr`wc'=1 if r`wc'hltc3>3 & r`wc'hltc3<9999999;
replace dsrphlth_nr`wc'=0 if r`wc'hltc3<=3 & dsrphlth_nr`wc'==.;

gen dsrphlth_better`wc'=1 if  r`wc'hltc3==1;
replace dsrphlth_better`wc'=0 if dsrphlth_better`wc'==. & dsrphlth_nr`wc'~=.;

gen dsrphlth_same`wc'=1 if  r`wc'hltc3==2;
replace dsrphlth_same`wc'=0 if dsrphlth_same`wc'==. & dsrphlth_nr`wc'~=.;

gen dsrphlth_worse`wc'=1 if  r`wc'hltc3==3;
replace dsrphlth_worse`wc'=0 if dsrphlth_worse`wc'==. & dsrphlth_nr`wc'~=.;

* };
*else {;
* Changes in Health;
* Omitted category is much worse;
**********************************;
*gen dsrphlth_nr`wc'=1 if r`wc'hltc5>5 & r`wc'hltc5~=.;
*replace dsrphlth_nr`wc'=0 if r`wc'hltc5<=5;

*gen dsrphlth_mbetter`wc'=1 if  r`wc'hltc5==1;
*replace dsrphlth_mbetter`wc'=0 if dsrphlth_mbetter`wc'==. & dsrphlth_nr`wc'~=.;

*gen dsrphlth_sbetter`wc'=1 if  r`wc'hltc5==2;
*replace dsrphlth_sbetter`wc'=0 if dsrphlth_sbetter`wc'==. & dsrphlth_nr`wc'~=.;

*gen dsrphlth_same`wc'=1 if  r`wc'hltc5==3;
*replace dsrphlth_same`wc'=0 if dsrphlth_same`wc'==. & dsrphlth_nr`wc'~=.;

*gen dsrphlth_sworse`wc'=1 if  r`wc'hltc5==4;
*replace dsrphlth_sworse`wc'=0 if dsrphlth_sworse`wc'==. & dsrphlth_nr`wc'~=.;

* new coding to collapse into 3 categories not 5;

*gen dsrphlth_nr`wc'=1 if r`wc'hltc5>5 & r`wc'hltc5~=.;
*replace dsrphlth_nr`wc'=0 if r`wc'hltc5<=5;

*gen dsrphlth_better`wc'=1 if  r`wc'hltc5==1 | r`wc'hltc5==2 ;
*replace dsrphlth_better`wc'=0 if dsrphlth_better`wc'==. & dsrphlth_nr`wc'~=.;

*gen dsrphlth_same`wc'=1 if  r`wc'hltc5==3;
*replace dsrphlth_same`wc'=0 if dsrphlth_same`wc'==. & dsrphlth_nr`wc'~=.;

*};

gen had_diabts`wc'=1 if r`wc'diab>=1 & r`wc'diab<=3;
replace had_diabts`wc'=0 if  r`wc'diab==0 |   r`wc'diab==4 |   r`wc'diab==.d |   r`wc'diab==.r;
gen had_diabts_nr`wc'=1 if r`wc'diab>.;
replace had_diabts_nr`wc'=0 if r`wc'diab<=5;

gen had_hbp`wc'=1 if r`wc'hibp>=1 & r`wc'hibp<=3;
replace had_hbp`wc'=0 if  r`wc'hibp==0 |   r`wc'hibp==4 |   r`wc'hibp==.d |   r`wc'hibp==.r;
gen had_hbp_nr`wc'=1 if r`wc'hibp>.;
replace had_hbp_nr`wc'=0 if r`wc'hibp<=5;

gen had_arth`wc'=1 if r`wc'arthr>=1 & r`wc'arthr<=3;
replace had_arth`wc'=0 if  r`wc'arthr==0 |   r`wc'arthr==4 |   r`wc'arthr==.d |   r`wc'arthr==.r;
gen had_arth_nr`wc'=1 if r`wc'arthr>.;
replace had_arth_nr`wc'=0 if r`wc'arthr<=5;

gen had_cancer`wc'=1 if r`wc'cancr>=1 & r`wc'cancr<=3;
replace had_cancer`wc'=0 if  r`wc'cancr==0 |   r`wc'cancr==4 |   r`wc'cancr==.d |   r`wc'cancr==.r;
gen had_cancer_nr`wc'=1 if r`wc'cancr>.;
replace had_cancer_nr`wc'=0 if r`wc'cancr<=5;

gen had_emphys`wc'=1 if r`wc'lung>=1 & r`wc'lung<=3;
replace had_emphys`wc'=0 if  r`wc'lung==0 |   r`wc'lung==4 |   r`wc'lung==.d |   r`wc'lung==.r;
gen had_emphys_nr`wc'=1 if r`wc'lung>.;
replace had_emphys_nr`wc'=0 if r`wc'lung<=5;

gen had_myocar`wc'=1 if r`wc'heart>=1 & r`wc'heart<=3;
replace had_myocar`wc'=0 if  r`wc'heart==0 |   r`wc'heart==4 |   r`wc'heart==.d |   r`wc'heart==.r;
gen had_myocar_nr`wc'=1 if r`wc'heart>.;
replace had_myocar_nr`wc'=0 if r`wc'heart<=5;

gen had_stroke`wc'=1 if r`wc'strok>=1 & r`wc'strok<=3;
replace had_stroke`wc'=0 if  r`wc'strok==0 |   r`wc'strok==4 |   r`wc'strok==.d |   r`wc'strok==.r;
gen had_stroke_nr`wc'=1 if r`wc'strok>.;
replace had_stroke_nr`wc'=0 if r`wc'strok<=5;

gen had_psych`wc'=1 if r`wc'psych>=1 & r`wc'psych<=3;
replace had_psych`wc'=0 if  r`wc'psych==0 |   r`wc'psych==4 |   r`wc'psych==.d |   r`wc'psych==.r;
gen had_psych_nr`wc'=1 if r`wc'psych>.;
replace had_psych_nr`wc'=0 if r`wc'psych<=5;


if `wc'>=4 & `wc'<=9 {;

gen had_alzhmr`wc'=1 if r`wc'memry>=1 & r`wc'memry<=3;
replace had_alzhmr`wc'=0 if  r`wc'memry==0 |   r`wc'memry==4 |   r`wc'memry==.d |   r`wc'memry==.r;
gen had_alzhmr_nr`wc'=1 if r`wc'memry>.;
replace had_alzhmr_nr`wc'=0 if r`wc'memry<=5;
};
if `wc'>=10 {;

gen had_alzhmr`wc'=1 if r`wc'alzhe>=1 & r`wc'alzhe<=3;
replace had_alzhmr`wc'=0 if  r`wc'alzhe==0 |   r`wc'alzhe==4 |   r`wc'alzhe==.d |   r`wc'alzhe==.r;
gen had_alzhmr_nr`wc'=1 if r`wc'alzhe>.;
replace had_alzhmr_nr`wc'=0 if r`wc'alzhe<=5;
};



gen working`wc'=1 if  r`wc'lbrf==1 | r`wc'lbrf==2 | r`wc'lbrf==3 | r`wc'lbrf==4;
replace  working`wc'=0 if  r`wc'lbrf==2 |  r`wc'lbrf==5 | r`wc'lbrf==`wc'  | r`wc'lbrf==7;

gen marst_married`wc'=1 if r6mstat==1 | r6mstat==2 | r6mstat==3;
replace  marst_married`wc'=0 if r6mstat==4 | r6mstat==5 | r6mstat==6  | r6mstat==7 | r6mstat==8  ;
gen marst_widow`wc'=1 if r6mstat==7;
replace  marst_widow`wc'=0 if r6mstat~=7 & r6mstat<=8;
gen marst_divor`wc'=1 if r6mstat==5 | r6mstat==6 ;
replace  marst_divor`wc'=0 if r6mstat==4 | r6mstat==7 | r6mstat==8  | r6mstat==1 | r6mstat==2 | r6mstat==3;
gen marst_separ`wc'=1 if r6mstat==4;
replace  marst_separ`wc'=0 if r6mstat~=4 & r6mstat<=8;

gen	h_resst`wc'= r`wc'cendiv;

if `wc'>1 {;
*was simply rename	r*shopa	diff_shop*;
* extra logic to handle nr;
* Example for .x special case. In difficulty shopping (diff_shop) FSK have included .x=don't do (650  observations) ;
* as a response but count that as a difficulty. Not sure don't do shopping is the same as difficulty shopping.;
* skip and refuse also special case;
gen diff_shop_nr`wc'=1 if r`wc'shopa>1 & r`wc'shopa~=.;
replace diff_shop_nr`wc'=0 if r`wc'shopa<=1 | r`wc'shopa==.x | r`wc'shopa==.s | r`wc'shopa==.r ;
gen diff_shop`wc'=1 if  r`wc'shopa==1 | r`wc'shopa==.x | r`wc'shopa==.r;
replace diff_shop`wc'=0 if diff_shop`wc'==. & diff_shop_nr`wc'~=.;

gen diff_walk_nr`wc'=1 if r`wc'walkra>1 & r`wc'walkra~=.;
replace diff_walk_nr`wc'=0 if r`wc'walkra<=1 | r`wc'walkra==.x | r`wc'walkra==.s | r`wc'walkra==.r ;
gen diff_walk`wc'=1 if  r`wc'walkra==1 | r`wc'walkra==.x | r`wc'walkra==.r;
replace diff_walk`wc'=0 if diff_walk`wc'==. & diff_walk_nr`wc'~=.;

gen diff_walkblks_nr`wc'=1 if r`wc'walksa>1 & r`wc'walksa~=.;
replace diff_walkblks_nr`wc'=0 if r`wc'walksa<=1 | r`wc'walksa==.x | r`wc'walksa==.s | r`wc'walksa==.r ;
gen diff_walkblks`wc'=1 if  r`wc'walksa==1 | r`wc'walksa==.x | r`wc'walksa==.r;
replace diff_walkblks`wc'=0 if diff_walkblks`wc'==. & diff_walkblks_nr`wc'~=.;

gen diff_stoop_nr`wc'=1 if r`wc'stoopa>1 & r`wc'stoopa~=.;
replace diff_stoop_nr`wc'=0 if r`wc'stoopa<=1 | r`wc'stoopa==.x | r`wc'stoopa==.s | r`wc'stoopa==.r ;
gen diff_stoop`wc'=1 if  r`wc'stoopa==1 | r`wc'stoopa==.x | r`wc'stoopa==.r;
replace diff_stoop`wc'=0 if diff_stoop`wc'==. & diff_stoop_nr`wc'~=.;

gen diff_lift_nr`wc'=1 if r`wc'lifta>1 & r`wc'lifta~=.;
replace diff_lift_nr`wc'=0 if r`wc'lifta<=1 | r`wc'lifta==.x | r`wc'lifta==.s | r`wc'lifta==.r ;
gen diff_lift`wc'=1 if  r`wc'lifta==1 | r`wc'lifta==.x | r`wc'lifta==.r;
replace diff_lift`wc'=0 if diff_lift`wc'==. & diff_lift_nr`wc'~=.;

gen diff_reach_nr`wc'=1 if r`wc'armsa>1 & r`wc'armsa~=.;
replace diff_reach_nr`wc'=0 if r`wc'armsa<=1 | r`wc'armsa==.x | r`wc'armsa==.s | r`wc'armsa==.r ;
gen diff_reach`wc'=1 if  r`wc'armsa==1 | r`wc'armsa==.x | r`wc'armsa==.r;
replace diff_reach`wc'=0 if diff_reach`wc'==. & diff_reach_nr`wc'~=.;

gen diff_char_nr`wc'=1 if r`wc'chaira>1 & r`wc'chaira~=.;
replace diff_char_nr`wc'=0 if r`wc'chaira<=1 | r`wc'chaira==.x | r`wc'chaira==.s | r`wc'chaira==.r ;
gen diff_char`wc'=1 if  r`wc'chaira==1 | r`wc'chaira==.x | r`wc'chaira==.r;
replace diff_char`wc'=0 if diff_char`wc'==. & diff_char_nr`wc'~=.;

gen diff_dres_nr`wc'=1 if r`wc'dressa>1 & r`wc'dressa~=.;
replace diff_dres_nr`wc'=0 if r`wc'dressa<=1 | r`wc'dressa==.x | r`wc'dressa==.s | r`wc'dressa==.r ;
gen diff_dres`wc'=1 if  r`wc'dressa==1 | r`wc'dressa==.x | r`wc'dressa==.r;
replace diff_dres`wc'=0 if diff_dres`wc'==. & diff_dres_nr`wc'~=.;

gen diff_bath_nr`wc'=1 if r`wc'batha>1 & r`wc'batha~=.;
replace diff_bath_nr`wc'=0 if r`wc'batha<=1 | r`wc'batha==.x | r`wc'batha==.s | r`wc'batha==.r ;
gen diff_bath`wc'=1 if  r`wc'batha==1 | r`wc'batha==.x | r`wc'batha==.r;
replace diff_bath`wc'=0 if diff_bath`wc'==. & diff_bath_nr`wc'~=.;

gen diff_eat_nr`wc'=1 if r`wc'eata>1 & r`wc'eata~=.;
replace diff_eat_nr`wc'=0 if r`wc'eata<=1 | r`wc'eata==.x | r`wc'eata==.s | r`wc'eata==.r ;
gen diff_eat`wc'=1 if  r`wc'eata==1 | r`wc'eata==.x | r`wc'eata==.r;
replace diff_eat`wc'=0 if diff_eat`wc'==. & diff_eat_nr`wc'~=.;

gen diff_toil_nr`wc'=1 if r`wc'toilta>1 & r`wc'toilta~=.;
replace diff_toil_nr`wc'=0 if r`wc'toilta<=1 | r`wc'toilta==.x | r`wc'toilta==.s | r`wc'toilta==.r ;
gen diff_toil`wc'=1 if  r`wc'toilta==1 | r`wc'toilta==.x | r`wc'toilta==.r;
replace diff_toil`wc'=0 if diff_toil`wc'==. & diff_toil_nr`wc'~=.;

gen diff_tele_nr`wc'=1 if r`wc'phonea>1 & r`wc'phonea~=.;
replace diff_tele_nr`wc'=0 if r`wc'phonea<=1 | r`wc'phonea==.x | r`wc'phonea==.s | r`wc'phonea==.r ;
gen diff_tele`wc'=1 if  r`wc'phonea==1 | r`wc'phonea==.x | r`wc'phonea==.r;
replace diff_tele`wc'=0 if diff_tele`wc'==. & diff_tele_nr`wc'~=.;

gen diff_bils_nr`wc'=1 if r`wc'moneya>1 & r`wc'moneya~=.;
replace diff_bils_nr`wc'=0 if r`wc'moneya<=1 | r`wc'moneya==.x | r`wc'moneya==.s | r`wc'moneya==.r ;
gen diff_bils`wc'=1 if  r`wc'moneya==1 | r`wc'moneya==.x | r`wc'moneya==.r;
replace diff_bils`wc'=0 if diff_bils`wc'==. & diff_bils_nr`wc'~=.;

gen diff_meal_nr`wc'=1 if r`wc'mealsa>1 & r`wc'mealsa~=.;
replace diff_meal_nr`wc'=0 if r`wc'mealsa<=1 | r`wc'mealsa==.x | r`wc'mealsa==.s | r`wc'mealsa==.r ;
gen diff_meal`wc'=1 if  r`wc'mealsa==1 | r`wc'mealsa==.x | r`wc'mealsa==.r;
replace diff_meal`wc'=0 if diff_meal`wc'==. & diff_meal_nr`wc'~=.;



/*
rename	r*chaira	diff_char*;
rename	r*dressa	diff_dres*;
rename	r*batha	diff_bath*;
rename	r*eata	diff_eat*;
rename	r*toilta	diff_toil*;
rename	r*phonea	diff_tele*;
rename	r*moneya	diff_bils*;
rename	r*mealsa	diff_meal*;
*/


};
  
local wc=`wc'+1;
};

rename r*smokev eversmoke*;
rename r*smoken smoker*;
*rename rahispan hispanic;
*rename h*child numkids*;  			
gen race_othr=1 if raracem==3;
replace race_othr=0 if raracem==1 | raracem==2;

gen had_alzhmr1=. ;
gen had_alzhmr2=. ;
gen had_alzhmr3=. ;
gen had_alzhmr_nr1=. ;
gen had_alzhmr_nr2=. ;
gen had_alzhmr_nr3=. ;



gen diff_walkblks1=. ;
gen diff_stoop1=. ;
gen diff_lift1=. ;
gen diff_reach1=. ;
gen diff_char1=. ;
gen diff_dres1=. ;
gen diff_bath1=. ;
gen diff_eat1=. ;
gen diff_toil1=. ;
gen diff_tele1=. ;
gen diff_bils1=. ;
gen diff_meal1=. ;
gen diff_walk1=. ;
gen diff_shop1=. ;

gen diff_walkblks_nr1=. ;
gen diff_stoop_nr1=. ;
gen diff_lift_nr1=. ;
gen diff_reach_nr1=. ;
gen diff_char_nr1=. ;
gen diff_dres_nr1=. ;
gen diff_bath_nr1=. ;
gen diff_eat_nr1=. ;
gen diff_toil_nr1=. ;
gen diff_tele_nr1=. ;
gen diff_bils_nr1=. ;
gen diff_meal_nr1=. ;
gen diff_walk_nr1=. ;
gen diff_shop_nr1=. ;

rename	r*dressh	help_dres*;
rename	r*walkrh	help_walk*;
rename	r*bathh	help_bath*;
rename	r*eath	help_eat*;
rename	r*toilth	help_toil*;
rename	r*phoneh	help_tele*;
rename	r*moneyh	help_bils*;
* bed used instead of chair; 
rename r*bedh	help_char*;   
gen help_char1=. ;
gen help_dres1=. ;
gen help_walk1=. ;
gen help_bath1=. ;
gen help_eat1=. ;
gen help_toil1=. ;

rename	r*mealsh	help_meal*;
rename	r*shoph	help_shop*;
gen help_meal1=. ;
gen help_meal2=. ;
gen help_shop1=. ;
gen help_shop2=. ;
gen help_tele1=. ;
gen help_bils1=. ;
gen help_tele2=. ;
gen help_bils2=. ;

*HALT;


* where the values is skipped helped questions set to 0, as no difficulty in the first place;
local wc = 1;
while `wc' <= 14 {;
replace  help_dres`wc'=0 if help_dres`wc'==.s;
replace  help_walk`wc'=0 if help_walk`wc'==.s;
replace  help_bath`wc'=0 if help_bath`wc'==.s;
replace  help_eat`wc'=0 if help_eat`wc'==.s;
replace  help_toil`wc'=0 if help_toil`wc'==.s;
replace  help_tele`wc'=0 if help_tele`wc'==.s;
replace  help_bils`wc'=0 if help_bils`wc'==.s;
replace  help_char`wc'=0 if help_char`wc'==.s;
replace  help_meal`wc'=0 if help_meal`wc'==.s;
replace  help_shop`wc'=0 if help_shop`wc'==.s;
local wc=`wc'+1;
};
 

***********************************************************************************************************************************;
* End of new code for Kang et al replication. Chris Dec 2022 and Jan 2023;
***********************************************************************************************************************************;






/* 10% sample */
*gen smaller = uniform();
*drop if smaller>.1 ;
*drop smaller;

/* generate HHID PN for people in the RAND dataset, not in the original HRS dataset */
gen temp0=hhidpn/1000;
gen temp1=round(temp0);
gen long temp2=temp1*1000;
gen long temp3=hhidpn-temp2;
replace HHID=temp1 if HHID==.;
replace PN=temp3 if PN==.;
replace HHIDPN=hhidpn if HHIDPN==.;
drop temp1 temp2 temp3;
/* drop people not in the RAND dataset */
tab _merge; * this is disturbing---who are these people who are in the RAND data but not in the basic HRS dataset?;
drop if _merge==1|_merge==2; * note: dropping if _merge==2 drops all households added in 2004;
*drop _merge;

sum rab*;
sort hhidpn;
list hhidpn if hhidpn==hhidpn[_n+1];
*list HHIDPN if HHIDPN==HHIDPN[_n+1]; * HHIDPN is not in long format--drop it;
drop HHIDPN;
gen long HHIDPN=hhidpn;



gen RANDwaves=14;
gen HRSwaves=14;
*gen RANDwaves=13;
*gen HRSwaves=13;

* re-code rand medical expense variables(out of pocket plus drugs);


* to compare against the oopd* variable I am creating;
gen oopd1=(oop1+drugc1);
gen oopd2=(oop2+drugc2);
gen oopd3=(oop3+drugc3);
gen oopd4=(oop4+drugc4);
gen oopd5=(oop5+drugc5);
gen oopd6=(oop6+drugc6);
gen oopd7=(oop7+drugc7);
gen oopd8=(oop8+drugc8);
gen oopd9=(oop9+drugc9);
gen oopd10=(oop10+drugc10);
gen oopd11=(oop11+drugc11);
gen oopd12=(oop12+drugc12);
gen oopd13=(oop13+drugc13);
gen oopd14=(oop14+drugc14);

* to compare against the oopd* variable I am creating;
gen _oopd1=(_oop1+_drugc1);
gen _oopd2=(_oop2+_drugc2);
gen _oopd3=(_oop3+_drugc3);
gen _oopd4=(_oop4+_drugc4);
gen _oopd5=(_oop5+_drugc5);
gen _oopd6=(_oop6+_drugc6);
gen _oopd7=(_oop7+_drugc7);
gen _oopd8=(_oop8+_drugc8);
gen _oopd9=(_oop9+_drugc9);
gen _oopd10=(_oop10+_drugc10);
gen _oopd11=(_oop11+_drugc11);
gen _oopd12=(_oop12+_drugc12);
gen _oopd13=(_oop13+_drugc13);
gen _oopd14=(_oop14+_drugc14);

*******************************************************;
*STOP;
* RAND DATA -- heads;
gen roopd1=r1oopmd if hrscoh==1;;
replace roopd1=r2oopmd if hrscoh==12|hrscoh==11;
gen roopd2=r2oopmd/2 if hrscoh==1;
replace roopd2=r3oopmd/2 if hrscoh==12|hrscoh==11;
gen roopd3=r3oopmd/2 if hrscoh==1;
gen roopd4=r4oopmd/2;
gen roopd5=r5oopmd/2;
gen roopd6=r6oopmd/2;
gen roopd7=r7oopmd/2;
gen roopd8=r8oopmd/2;
gen roopd9=r9oopmd/2;
gen roopd10=r10oopmd/2;
gen roopd11=r11oopmd/2;
gen roopd12=r12oopmd/2;
gen roopd13=r13oopmd/2;
gen roopd14=r14oopmd/2;


* RAND DATA--spouses (if present);
gen _roopd1=s1oopmd if hrscoh==1;
replace _roopd1=s2oopmd if hrscoh==12|hrscoh==11;
gen _roopd2=s2oopmd/2 if hrscoh==1;
replace _roopd2=s3oopmd/2 if hrscoh==12|hrscoh==11;
gen _roopd3=s3oopmd/2 if hrscoh==1;
gen _roopd4=s4oopmd/2;
gen _roopd5=s5oopmd/2;
gen _roopd6=s6oopmd/2;
gen _roopd7=s7oopmd/2;
gen _roopd8=s8oopmd/2;
gen _roopd9=s9oopmd/2;
gen _roopd10=s10oopmd/2;
gen _roopd11=s11oopmd/2;
gen _roopd12=s12oopmd/2;
gen _roopd13=s13oopmd/2;
gen _roopd14=s14oopmd/2;

gen rmarried1=r1mstat if hrscoh==1;
replace rmarried1=r2mstat if hrscoh==11|hrscoh==12;
gen rmarried2=r2mstat if hrscoh==1;
replace rmarried2=r3mstat if hrscoh==11|hrscoh==12;
gen rmarried3=r3mstat if hrscoh==1;
gen rmarried4=r4mstat;
gen rmarried5=r5mstat;
gen rmarried6=r6mstat;
gen rmarried7=r7mstat;
gen rmarried8=r8mstat;
gen rmarried9=r9mstat;
gen rmarried10=r10mstat;
gen rmarried11=r11mstat;
gen rmarried12=r12mstat;
gen rmarried13=r13mstat;
gen rmarried14=r14mstat;

gen wgtr1=r1wtresp if hrscoh==1;;
replace wgtr1=r2wtresp if hrscoh==11|hrscoh==12;
gen wgtr2=r2wtresp if hrscoh==1;
replace wgtr2=r3wtresp if hrscoh==11|hrscoh==12;
gen wgtr3=r3wtresp if hrscoh==1;
gen wgtr4=r4wtresp;
gen wgtr5=r5wtresp;
gen wgtr6=r6wtresp;
gen wgtr7=r7wtresp;
gen wgtr8=r8wtresp;
gen wgtr9=r9wtresp;
gen wgtr10=r10wtresp;
gen wgtr11=r11wtresp;
gen wgtr12=r12wtresp;
gen wgtr13=r13wtresp;
gen wgtr14=r14wtresp;

gen wgthh1=r1wthh if hrscoh==1;;
replace wgthh1=r2wthh if hrscoh==11|hrscoh==12;
gen wgthh2=r2wthh if hrscoh==1;
replace wgthh2=r3wthh if hrscoh==11|hrscoh==12;
gen wgthh3=r3wthh if hrscoh==1;
gen wgthh4=r4wthh;
gen wgthh5=r5wthh;
gen wgthh6=r6wthh;
gen wgthh7=r7wthh;
gen wgthh8=r8wthh;
gen wgthh9=r9wthh;
gen wgthh10=r10wthh;
gen wgthh11=r11wthh;
gen wgthh12=r12wthh;
gen wgthh13=r13wthh;
gen wgthh14=r14wthh;

gen children1=h1child if hrscoh==1;
replace children1=h2child if hrscoh==11|hrscoh==12;
gen children2=h2child if hrscoh==1;
replace children2=h3child if hrscoh==11|hrscoh==12;
gen children3=h3child if hrscoh==1;
gen children4=h4child;
gen children5=h5child;
gen children6=h6child;
gen children7=h7child;
gen children8=h8child;
gen children9=h9child;
gen children10=h10child;
gen children11=h11child;
gen children12=h12child;
gen children13=h13child;
gen children14=h14child;
* veteran status;
gen rvetrn=ravetrn;


* diagnostics here;
*reg roopd2 oopd2 if hrscoh==1; //this was ucommented
*reg roopd2 oopd2 if hrscoh==11;
*reg roopd2 oopd2 if hrscoh==12;
reg roopd3 oopd3 if hrscoh==1;
sum roopd1 roopd2 roopd3 roopd4 roopd5 roopd6 if age1<65 & hrscoh==1;


gen HHID10=10*HHID;

gen rsub1w1=(h1hhid-(HHID10)) if hrscoh==1;
replace rsub1w1=(h2hhid-HHID10) if hrscoh==11|hrscoh==12;
gen rsub2w2=(h2hhid-HHID10) if hrscoh==1;
replace rsub2w2=(h3hhid-HHID10) if hrscoh==11|hrscoh==12;
gen rsub3w3=(h3hhid-HHID10) if hrscoh==1;
gen rsub4w4=(h4hhid-HHID10);
gen rsub5w5=(h5hhid-HHID10);
gen rsub6w6=(h6hhid-HHID10);
gen rsub7w7=(h7hhid-HHID10);
gen rsub8w8=(h8hhid-HHID10);
gen rsub9w9=(h9hhid-HHID10);
gen rsub10w10=(h10hhid-HHID10);
gen rsub11w11=(h11hhid-HHID10);
gen rsub12w12=(h12hhid-HHID10);
gen rsub13w13=(h13hhid-HHID10);
gen rsub14w14=(h14hhid-HHID10);

* note: RAND often seems to give people subhousehold ids =3 when dead;
*replace rsub7w7 =. if (r7iwstat==5|r7iwstat==6); * 5,6 ==> dead;

replace rsub14w14 =. if dead14==1;
replace rsub13w13 =. if dead13==1;
replace rsub12w12 =. if dead12==1;
replace rsub11w11 =. if dead11==1;
replace rsub10w10 =. if dead10==1;
replace rsub9w9 =. if dead9==1;
replace rsub8w8 =. if dead8==1;
replace rsub7w7 =. if dead7==1;
replace rsub6w6 =. if dead6==1;
replace rsub5w5 =. if dead5==1;
replace rsub4w4 =. if dead4==1;
replace rsub3w3 =. if dead3==1;
replace rsub2w2=. if dead2==1;
replace rsub1w1=. if dead1==1;

reg rsub1w1 sub1w1;
reg rsub2w2 sub2w2;
reg rsub3w3 sub3w3;
reg rsub4w4 sub4w4;
reg rsub5w5 sub5w5;
reg rsub6w6 sub6w6;
reg rsub7w7 sub7w7;
reg rsub8w8 sub8w8;
reg rsub9w9 sub9w9;
reg rsub10w10 sub10w10;
reg rsub11w11 sub11w11;
reg rsub12w12 sub12w12;
reg rsub13w13 sub13w13;
reg rsub14w14 sub14w14;
*tab rsub1w1 sub1w1;
*tab rsub2w2 sub2w2;
*tab rsub3w3 sub3w3;
*tab rsub4w4 sub4w4;
*tab rsub5w5 sub5w5;
*tab rsub6w6 sub6w6;
*tab rsub7w7 sub7w7;
*tab rsub8w8 sub8w8;
*tab rsub9w9 sub9w9;
*tab rsub10w10 sub10w10;
*tab rsub11w11 sub11w11;

replace sub2w2=rsub2w2 if sub2w2==.;
replace sub3w3=rsub3w3 if sub3w3==.;
replace sub4w4=rsub4w4 if sub4w4==.;
replace sub5w5=rsub5w5 if sub5w5==.;
replace sub6w6=rsub6w6 if sub6w6==.;
replace sub7w7=rsub7w7 if sub7w7==.;
replace sub8w8=rsub8w8 if sub8w8==.;
replace sub9w9=rsub9w9 if sub9w9==.;
replace sub10w10=rsub10w10 if sub10w10==.;
replace sub11w11=rsub11w11 if sub11w11==.;
replace sub12w12=rsub12w12 if sub12w12==.;
replace sub13w13=rsub13w13 if sub13w13==.;
replace sub14w14=rsub14w14 if sub14w14==.;


**********************************************************************************************************************;
** Start Assets**;
**********************************************************************************************************************;


program define testx7;
  local counter = 1;
  while `counter' <= RANDwaves {;
   local counter2 = `counter'-1;
    
    gen rhouse`counter'= h`counter'ahous ;  * Primary Residency;
if `counter'>1{;
    replace  rhouse`counter2'= h`counter'ahous  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rhouse`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

    gen rhouse_flag`counter'= h`counter'afhous ;  * Primary Residency;
if `counter'>1{;
    replace  rhouse_flag`counter2'= h`counter'afhous  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rhouse_flag`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};



* RAND splits this up into 1st and second home mortgages ;
* (h`counter'amorth) and home equity lines, etc          ;

    gen rmort`counter'= (h`counter'amort+h`counter'ahmln); *house mortgage;
if `counter'>1{;
    replace  rmort`counter2'= (h`counter'amort+h`counter'ahmln)  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rmort`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

* RAND does not code up an analogue to remort, which is mortgage on the second home;
* the also omit second home on when calculating re (they seem to include only      ;
* all other real estate);

*    gen rremort`counter'= h`counter'ahmln; *other home loans;
*if `counter'>1{;    
*    replace  rremort`counter2'= h`counter'ahmln  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
*    replace  rremort`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
*};
    gen rwheels`counter' = h`counter'atran; *Transit assets;
if `counter'>1{; 
    replace  rwheels`counter2'= h`counter'atran  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rwheels`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

* IRA1 and rIRA1 are pretty different--it looks like this;
* is due to differences in imputation procedures between ;
* the HRS and RAND                                       ;

    gen rIRA`counter'= h`counter'aira; *IRA account;
if `counter'>1{;
    replace  rIRA`counter2'= h`counter'aira  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rIRA`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen h`counter'cdck = h`counter'acd + h`counter'achck; 
    gen rliquid`counter' = h`counter'cdck; * CDs/savings bonds + checking/savings accounts;
if `counter'>1{;
    replace  rliquid`counter2'= h`counter'cdck if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rliquid`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rstock`counter'= h`counter'astck ; * stocks and trusts;
if `counter'>1{;    
    replace  rstock`counter2'= h`counter'astck if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rstock`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rtrust`counter' = 0;*RAND does not impute trusts-do not even consider them in asset evaluation; 

    gen rbus`counter' = h`counter'absns; *BUSINESS OR FARM $;
if `counter'>1{;    
    replace  rbus`counter2'= h`counter'absns if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rbus`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

    gen rbonds`counter'= h`counter'abond; * Bonds;
if `counter'>1{;    
    replace  rbonds`counter2'= h`counter'abond if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rbonds`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rexasset`counter' = h`counter'aothr; * Other savings/assets;
if `counter'>1{;    
    replace  rexasset`counter2'= h`counter'aothr if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rexasset`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rdebts`counter' = h`counter'adebt ; * Other debts not yet discussed;
if `counter'>1{;    
    replace  rdebts`counter2'= h`counter'adebt if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rdebts`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rre`counter'=h`counter'arles;
if `counter'>1{;
    replace  rre`counter2'= h`counter'arles if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rre`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
};  
    gen rassetsnon`counter'=h`counter'atotn;  
if `counter'>1{;
    replace  rassetsnon`counter2'= h`counter'atotn if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rassetsnon`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
}; 

* Chris *********** KEY TEMPORARY CHANGE;
*    gen rassetstotal`counter'=h`counter'atota;  
*if `counter'>1{;
*    replace  rassetstotal`counter2'= h`counter'atota if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
*    replace rassetstotal`counter' =. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
*}; 
 * end while ;

 
if `counter'<6{;  
    regress house`counter' rhouse`counter';
    regress mort`counter' rmort`counter';
    regress re`counter' rre`counter';
    regress wheels`counter' rwheels`counter';
    regress liquid`counter' rliquid`counter';
    regress IRA`counter' rIRA`counter';
    regress stock`counter' rstock`counter';
    regress bus`counter' rbus`counter';
    regress bonds`counter' rbonds`counter';
    regress exasset`counter' rexasset`counter';
    regress debts`counter' rdebts`counter';

};

    local counter = `counter' + 1;
}; 
* end program ;

sum h1ahous;
sort hrscoh;
by hrscoh: sum rhouse* house*;
by hrscoh: sum r*mstat married*;
by hrscoh: sum rmort* mort*;
* by hrscoh: sum rremort* remort*;
by hrscoh: sum rwheels* wheels*;
by hrscoh: sum rIRA* IRA*;
by hrscoh: sum rliquid*  liquid*;
by hrscoh: sum rstock* stock*;
by hrscoh: sum rbus* bus*;
by hrscoh: sum rbonds* bonds*;
by hrscoh: sum rexasset* exasset*;
by hrscoh: sum rdebts* debts*;

end;


testx7;

**********************************************************************************************************************;
*employ.do and tenure.do variables;
**********************************************************************************************************************;
program define testx8;
   local counter = 1;
   while `counter' <= RANDwaves {;
   local counter2 = `counter'-1;
    
    gen rocc`counter'= r`counter'jcocc ; * Occupation (Respondent);
if `counter'>1{;
    replace rocc`counter2' = r`counter'jcocc if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rocc`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen _rocc`counter'= s`counter'jcocc ; * Occupation (Spouse);
if `counter'>1{;
    replace _rocc`counter2' = s`counter'jcocc if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rocc`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rind`counter'= r`counter'jcind ; * Industry (Respondent);
if `counter'>1{;
    replace rind`counter2' = r`counter'jcind  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rind`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen _rind`counter'= s`counter'jcind ; * Industry (Spouse);
if `counter'>1{;
    replace _rind`counter2' = s`counter'jcind  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rind`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};


    gen rhours`counter'= r`counter'jhours; * Hours/week at Primary Job (Respondent);
if `counter'>1{;
    replace rhours`counter2' = r`counter'jhours   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rhours`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen _rhours`counter'= s`counter'jhours; * Hours/week at Primary Job (Spouse);
if `counter'>1{;
    replace _rhours`counter2' = s`counter'jhours   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rhours`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};



    gen rlfpr`counter'= r`counter'work; * Starts the lfpr variable to track work (Respondent);
if `counter'>1{;
    replace rlfpr`counter2' = r`counter'work if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rlfpr`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};


    gen _rlfpr`counter'= s`counter'work; * Starts the lfpr variable to track work (Respondent);
if `counter'>1{;
    replace _rlfpr`counter2' = s`counter'work if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rlfpr`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};


    gen rhours2job`counter'= r`counter'jhour2;* Hours/week at Secondary Job (Respondent);
if `counter'>1{;
    replace rhours2job`counter2' = r`counter'jhour2   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rhours2job`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};  
    gen _rhours2job`counter'= s`counter'jhour2;* Hours/week at Secondary Job (Spouse);
if `counter'>1{;
    replace _rhours2job`counter2' = s`counter'jhour2   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rhours2job`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rweeks`counter'= r`counter'jweeks;* Weeks/year at Primary Job (Respondent);
if `counter'>1{;
    replace rweeks`counter2' = r`counter'jweeks   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rweeks`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
};
    gen _rweeks`counter'= s`counter'jweeks;* Weeks/year at Primary Job (Spouse);
if `counter'>1{;
    replace _rweeks`counter2' = s`counter'jweeks   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rweeks`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
};
    gen rweeks2job`counter'=  r`counter'jweek2;* Weeks/year at Secondary Job (Respondent);
if `counter'>1{;
    replace rweeks2job`counter2' =  r`counter'jweek2   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rweeks2job`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
};
    gen _rweeks2job`counter'=  s`counter'jweek2;* Weeks/year at Secondary Job (Spouse);
if `counter'>1{;
    replace _rweeks2job`counter2' =  s`counter'jweek2   if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rweeks2job`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
};   

/* DO I USE THIS WEEKS RATIO THING?  IT LOOKS LIKE GARBAGE  How much of the year was spent working?*/
*    gen rwkrat1`counter'=rweeks`counter'/52; 
*if `counter'>1{;
*    replace  rwkrat1`counter2' =rweeks`counter'/52  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
*    replace  rwkrat1`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
*};
*    gen  rwkrat2`counter'=rweeks2p`counter'/52; * How much of the year was spent working? (spouse);
*if `counter'>1{;
*    replace rwkrat2`counter2' = rweeks2p`counter'/52  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
*    replace rwkrat2`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ; 
*};
   
gen rquit`counter'= r`counter'jlasty + (r`counter'jlastm/12); 
if `counter'>1{;
    replace rquit`counter2' = r`counter'jlasty + (r`counter'jlastm/12) if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rquit`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

gen rintdate`counter'= (r`counter'iwmid)/365 + 1960;
if `counter'>1{;
    replace rintdate`counter2' = (r`counter'iwmid)/365 + 1960 if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rintdate`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

    gen rwage`counter' = r`counter'wgihr; * Imputed $/hour (Respondent);
if `counter'>1{;
    replace rwage`counter2' =r`counter'wgihr  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rwage`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen _rwage`counter' = s`counter'wgihr; * Imputed $/hour (Spouse);
if `counter'>1{;
    replace _rwage`counter2' =s`counter'wgihr  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rwage`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};


    gen  rtenure`counter' = r`counter'jcten; *Years of tenure on current job(respondent);
if `counter'>1{;
    replace rtenure`counter2' = r`counter'jcten  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rtenure`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen  _rtenure`counter' = s`counter'jcten; *Years of tenure on current job(spouse);
if `counter'>1{;
    replace _rtenure`counter2' = s`counter'jcten  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rtenure`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

* this is very different from eric's coding;
*  RAND==> =1 if VA\CHAMPUS==1 or Medicare ==1 or Medicaid==1;
*  ERIC==> =1 if VA\CHAMPUS==1 (or if you are a postal\X-postal worker), =2 if Medicaid==1, ==0 if Medcare==1;
*    gen  rinsgov`counter' = r`counter'higov; * Government provided insurance;
*if `counter'>1{;
*    replace rinsgov`counter2' = r`counter'higov if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
*    replace rinsgov`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
*};

*other (mostly VA/CHAMPUS);
   gen  rinsgov`counter' = r`counter'govva; * Government provided insurance;
if `counter'>1{;
    replace rinsgov`counter2' = r`counter'govva if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rinsgov`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

* indicator for whether spouse was a veteran  -- whether self was veteran was coded above;
   gen _rvetrn`counter' = s`counter'vetrn; 
if `counter'>1{;
    replace _rvetrn`counter2' = s`counter'vetrn if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rvetrn`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};



*medicaid;
    gen  rmedicaid`counter' = r`counter'govmd; * Government provided insurance;
if `counter'>1{;
    replace rmedicaid`counter2' = r`counter'govmd if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rmedicaid`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

* medicare;
    gen  rmedcare`counter' = r`counter'govmr; * Government provided insurance;
if `counter'>1{;
    replace rmedcare`counter2' = r`counter'govmr if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rmedcare`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};



    gen  repins`counter' = r`counter'covs+r`counter'covr; * Employer provided health insurance from self or spouse?;
if `counter'>1{;
    replace repins`counter2' = r`counter'covs+r`counter'covr if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace repins`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};


    gen  rinspriv`counter' = r`counter'hiothp; * Private health insurance;
if `counter'>1{;
    replace rinspriv`counter2' = r`counter'hiothp if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rinspriv`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};



    gen  rinssp`counter' = r`counter'covs; * Employer provided health insurance from self or spouse?;
if `counter'>1{;
    replace rinssp`counter2' = r`counter'covs if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rinssp`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};


    gen  reprhi`counter' = r`counter'covs+r`counter'covrt; * does employer provide retiree health insurance? (or do you get insurance from your spouse);
if `counter'>1{;
    replace reprhi`counter2' = r`counter'covs+r`counter'covrt if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace reprhi`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

    local counter = `counter' + 1;
  };


sort hrscoh;
by hrscoh: sum repins* epins*;
by hrscoh: sum rinspriv* inspriv*;
by hrscoh: sum rinssp* inssp*;
by hrscoh: sum reprhi* eprhi*;


  
  
end;
testx8;






/*
gen rinsgov1=rinsot1+(rmedicaid1*2);
gen rinsgov2=rinsot2+(rmedicaid2*2);
gen rinsgov3=rinsot3+(rmedicaid3*2);
gen rinsgov4=rinsot4+(rmedicaid4*2);
gen rinsgov5=rinsot5+(rmedicaid5*2);
gen rinsgov6=rinsot6+(rmedicaid6*2);
gen rinsgov7=rinsot7+(rmedicaid7*2);
gen rinsgov8=rinsot8+(rmedicaid8*2);
*/


*sum *weeks2* *hours2*;
 * exit;



sum rwage*;


**********************************************************************************************************************;
*employx.do and total assets variables --- some re-coding;
**********************************************************************************************************************;
program define testx9z;
  local counter = 1;
   while `counter' <= RANDwaves {;
   local counter2 = `counter'-1;
   local counter3 = `counter'-2;
   local counterp1= `counter'+1;

* own job;
replace rweeks`counter'=0 if rlfpr`counter'==0;
replace rhours`counter'=0 if rweeks`counter'==0;
replace rweeks2job`counter'=0 if rweeks2job`counter'==. & rweeks`counter'~=.;
*replace rweeks2job`counter'=0 if (rweeks`counter'~=. & rweeks2job`counter'==.); * new line;
replace rhours2job`counter'=0 if rhours2job`counter'==. & rweeks2job`counter'~=.;
*replace rhours2job`counter'=0 if (rweeks`counter'~=. & rhours2job`counter'==.); * new line;


gen tempz`counter'=(rhours2job`counter'*rweeks2job`counter');
replace tempz`counter'=0 if tempz`counter'==.|(rhours2job`counter'>95|rweeks2job`counter'>52);
gen temp`counter'=(rhours`counter'*rweeks`counter')+tempz`counter';
replace temp`counter'=. if (rhours`counter'>95|rweeks`counter'>52);
replace rhours`counter'=temp`counter';
drop temp*`counter';

*bomb;
*exit;

* topcoding and bottom coding decisions here;
replace rhours`counter'=0 if (rhours`counter'>0 & rhours`counter'<300);
replace rwage`counter'=. if (rhours`counter'>5000|rhours`counter'<300|rwage`counter'>200|rwage`counter'<3);
replace rlfpr`counter'=0 if rhours`counter'==0;
replace rhours`counter'=5000 if rhours`counter'>5000 & rhours`counter'~=.;


    gen rearn`counter' = rwage`counter'*rhours`counter'; * Calculate Earnings per week;

*spouses job;
replace _rweeks`counter'=0 if _rlfpr`counter'==0;
replace _rhours`counter'=0 if _rweeks`counter'==0;
replace _rweeks2job`counter'=0 if _rweeks2job`counter'==. & _rweeks`counter'~=.;
replace _rhours2job`counter'=0 if _rhours2job`counter'==. & _rweeks2job`counter'~=.;

gen temp`counter'=(_rhours`counter'*_rweeks`counter')+(_rhours2job`counter'*_rweeks2job`counter');
replace temp`counter'=. if (_rhours`counter'>95|_rweeks`counter'>52|_rhours2job`counter'>95|_rweeks2job`counter'>52);
replace _rhours`counter'=temp`counter';
drop temp`counter';

* topcoding and bottom coding decisions here;
replace _rhours`counter'=0 if (_rhours`counter'>0 & _rhours`counter'<300);
replace _rwage`counter'=. if (_rhours`counter'>5000|_rhours`counter'<300|_rwage`counter'>200|_rwage`counter'<3);
replace _rlfpr`counter'=0 if _rhours`counter'==0;
replace _rhours`counter'=5000 if _rhours`counter'>5000 & _rhours`counter'~=.;

 gen _rearn`counter' = _rwage`counter'*_rhours`counter'; * Calculate Earnings per week;

* other variables (insurance, etc.);

replace reprhi`counter'=0 if repins`counter'==0;
replace reprhi`counter'=0 if repins`counter'~=. & reprhi`counter'==.; * this is an ugly coding decision, but I do not want to lose the obs;


/****************************************************************************************/
/********participation 1 and 2 years ago                  *******************************/
/****************************************************************************************/

if `counter'>1{;
gen rlfpra`counter'=.;
replace rlfpra`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0;
replace rlfpra`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1;
replace rlfpra`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-1) & rlfpra`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfpra`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-1) & rlfpra`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfpra`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>1) & rlfpra`counter'==. & rtenure`counter'~=.;
replace rlfpra`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=1) & rlfpra`counter'==. & rtenure`counter'~=.;

sum rlfpra`counter';
};


if `counter'>1{;
gen rlfprb`counter'=.;
replace rlfprb`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0;
replace rlfprb`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1;
replace rlfprb`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-2) & rlfprb`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprb`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-2) & rlfprb`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprb`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>2) & rlfprb`counter'==. & rtenure`counter'~=.;
replace rlfprb`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=2) & rlfprb`counter'==. & rtenure`counter'~=.;
};



/********************************************************************************************/
/**********  aditional measures of participation at different points of your AGE, at birthday (not year) */
/********************************************************************************************/
gen time_since_birthday`counter'=(r`counter'agem_m)/12-r`counter'agey_m;
gen rlfprz`counter'=.;
gen rlfprza`counter'=.;
gen rlfprzb`counter'=.;

if `counter'>1{;
replace rlfprz`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0;
replace rlfprz`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1;
replace rlfprz`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-time_since_birthday`counter') & rlfprz`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprz`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-time_since_birthday`counter') & rlfprz`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprz`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>time_since_birthday`counter') & rlfprz`counter'==. & rtenure`counter'~=.;
replace rlfprz`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=time_since_birthday`counter') & rlfprz`counter'==. & rtenure`counter'~=.;
};


if `counter'==1{;
*replace rlfprz`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0;
*replace rlfprz`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1;
replace rlfprz`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-time_since_birthday`counter') & rlfprz`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprz`counter'=0 if rlfpr`counter'==0 & rquit`counter'==. & rlfprz`counter'==. & rintdate`counter'~=. & (hrscoh==1|hrscoh==11|hrscoh==12);
replace rlfprz`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-time_since_birthday`counter') & rlfprz`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprz`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>time_since_birthday`counter') & rlfprz`counter'==. & rtenure`counter'~=.;
replace rlfprz`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=time_since_birthday`counter') & rlfprz`counter'==. & rtenure`counter'~=.;
};


if `counter'>1{;
replace rlfprza`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0;
replace rlfprza`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1;
replace rlfprza`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-(time_since_birthday`counter'+1)) & rlfprza`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprza`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-(time_since_birthday`counter'+1)) & rlfprza`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprza`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>(time_since_birthday`counter'+1)) & rlfprza`counter'==. & rtenure`counter'~=.;
replace rlfprza`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=(time_since_birthday`counter'+1)) & rlfprza`counter'==. & rtenure`counter'~=.;

sum rlfprza`counter';
};


if `counter'>1{;
replace rlfprzb`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0;
replace rlfprzb`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1;
replace rlfprzb`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-(time_since_birthday`counter'+2)) & rlfprzb`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprzb`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-(time_since_birthday`counter'+2)) & rlfprzb`counter'==. & rquit`counter'~=. & rintdate`counter'~=.;
replace rlfprzb`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>(time_since_birthday`counter'+2)) & rlfprzb`counter'==. & rtenure`counter'~=.;
replace rlfprzb`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=(time_since_birthday`counter'+2)) & rlfprzb`counter'==. & rtenure`counter'~=.;
};





/********************************************************************************************/
/**********  aditional measures of participation at different points of your AGE, at birthday + 6 months (not year) */
/********************************************************************************************/
*gen time_since_birthday`counter'=(r`counter'agem_m)/12-r`counter'agey_m;
gen rlfprzz`counter'=.;
gen rlfprzza`counter'=.;
gen rlfprzzb`counter'=.;


gen time_minus_half`counter' = .;

replace time_minus_half`counter' = time_since_birthday`counter' -.5 if time_since_birthday`counter'>.5;
replace time_minus_half`counter' = time_since_birthday`counter' +.5 if time_since_birthday`counter'<=.5;




  if `counter'>1{;
    replace rlfprzz`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0 & time_minus_half`counter'<.499;
    replace rlfprzz`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1 & time_minus_half`counter'<.499;;
    replace rlfprzz`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-time_minus_half`counter') & rlfprzz`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;;
    replace rlfprzz`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-time_minus_half`counter') & rlfprzz`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;;
    replace rlfprzz`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>time_minus_half`counter') & rlfprzz`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;;
    replace rlfprzz`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=time_minus_half`counter') & rlfprzz`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;;
  };

  if `counter'==1{;
    replace rlfprzz`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-time_minus_half`counter') & rlfprzz`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzz`counter'=0 if rlfpr`counter'==0 & rquit`counter'==. & rlfprzz`counter'==. & rintdate`counter'~=. & (hrscoh==1|hrscoh==11|hrscoh==12) & time_minus_half`counter'<.499;
    replace rlfprzz`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-time_minus_half`counter') & rlfprzz`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzz`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>time_minus_half`counter') & rlfprzz`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzz`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=time_minus_half`counter') & rlfprzz`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;
  };


  if `counter'>1{;
    replace rlfprzza`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0 & time_minus_half`counter'<.499;
    replace rlfprzza`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1 & time_minus_half`counter'<.499;
    replace rlfprzza`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-(time_minus_half`counter'+1)) & rlfprzza`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzza`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-(time_minus_half`counter'+1)) & rlfprzza`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzza`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>(time_minus_half`counter'+1)) & rlfprzza`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzza`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=(time_minus_half`counter'+1)) & rlfprzza`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;
  };


  if `counter'>1{;
    replace rlfprzzb`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0 & time_minus_half`counter'<.499 ;
    replace rlfprzzb`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1 & time_minus_half`counter'<.499;
    replace rlfprzzb`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= (rintdate`counter'-(time_minus_half`counter'+2)) & rlfprzzb`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499 ;
    replace rlfprzzb`counter'=1 if rlfpr`counter'==0 & rquit`counter'> (rintdate`counter'-(time_minus_half`counter'+2)) & rlfprzzb`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzzb`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>(time_minus_half`counter'+2)) & rlfprzzb`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;
    replace rlfprzzb`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=(time_minus_half`counter'+2)) & rlfprzzb`counter'==. & rtenure`counter'~=. & time_minus_half`counter'<.499;
  };



if `counter'<RANDwaves{;
replace rlfprzz`counter'=0 if rlfpr`counterp1'==0 & rlfpr`counter'==0 & time_minus_half`counter'>=0.499;
replace rlfprzz`counter'=1 if rlfpr`counterp1'==1 & rlfpr`counter'==1 & time_minus_half`counter'>=0.499;
replace rlfprzz`counter'=0 if rlfpr`counterp1'==0 & rquit`counterp1'<= (rintdate`counter'+(1-time_minus_half`counter')) & rlfprzz`counter'==. & rquit`counterp1'~=. & rintdate`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzz`counter'=1 if rlfpr`counterp1'==0 & rquit`counterp1'> (rintdate`counter'+(1-time_minus_half`counter')) & rlfprzz`counter'==. & rquit`counterp1'~=. & rintdate`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzz`counter'=1 if rlfpr`counterp1'==1 & (rtenure`counterp1'> (rintdate`counterp1' - (rintdate`counter' + (1 - time_minus_half`counter')))) & rlfprzz`counter'==. & rtenure`counterp1'~=. & time_minus_half`counter'>=0.499;
replace rlfprzz`counter'=1 if rlfpr`counterp1'==1 & (rtenure`counterp1'<= (rintdate`counterp1' - (rintdate`counter' + (1 - time_minus_half`counter')))) & rlfprzz`counter'==. & rtenure`counterp1'~=. & time_minus_half`counter'>=0.499;
};

if `counter'>1{;
replace rlfprzza`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0 & time_minus_half`counter'>=0.499;
replace rlfprzza`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1 & time_minus_half`counter'>=0.499;
replace rlfprzza`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= ((rintdate`counter'-time_minus_half`counter')) & rlfprzza`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzza`counter'=1 if rlfpr`counter'==0 & rquit`counter'> ((rintdate`counter'-time_minus_half`counter')) & rlfprzza`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzza`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>(time_minus_half`counter')) & rlfprzza`counter'==. & rtenure`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzza`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=(time_minus_half`counter')) & rlfprzza`counter'==. & rtenure`counter'~=. & time_minus_half`counter'>=0.499;
};


if `counter'>1{;
replace rlfprzzb`counter'=0 if rlfpr`counter2'==0 & rlfpr`counter'==0 & time_minus_half`counter'>=0.499;
replace rlfprzzb`counter'=1 if rlfpr`counter2'==1 & rlfpr`counter'==1 & time_minus_half`counter'>=0.499;
replace rlfprzzb`counter'=0 if rlfpr`counter'==0 & rquit`counter'<= ((rintdate`counter'-time_minus_half`counter'-1)) & rlfprzzb`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzzb`counter'=1 if rlfpr`counter'==0 & rquit`counter'> ((rintdate`counter'-time_minus_half`counter'-1)) & rlfprzzb`counter'==. & rquit`counter'~=. & rintdate`counter'~=. & time_minus_half`counter'>=0.499;
replace rlfprzzb`counter'=1 if rlfpr`counter'==1 & (rtenure`counter'>(time_minus_half`counter'+1)) & rlfprzzb`counter'==. & rtenure`counter'~=. & time_minus_half`counter'>=0.499 ;
replace rlfprzzb`counter'=0 if rlfpr`counter'==1 & (rtenure`counter'<=(time_minus_half`counter'+1))  & rlfprzzb`counter'==. & rtenure`counter'~=. & time_minus_half`counter'>=0.499;
};



/******* end of age based participation coding **********************************************************/







    gen rnohouse`counter'=rre`counter'+rwheels`counter'+rliquid`counter'+rIRA`counter'+rstock`counter'+rbus`counter'+rbonds`counter'+rexasset`counter'-rdebts`counter';
    gen rassets`counter'=rhouse`counter'+rnohouse`counter'-rmort`counter';


if `counter'<=HRSwaves {; 
    regress  occ`counter' rocc`counter';
    regress ind`counter' rind`counter';
    regress hours`counter' rhours`counter';
    regress lfpr`counter'  rlfpr`counter';
    regress weeks`counter' rweeks`counter';
    regress hours`counter' rhours`counter';
    regress wage`counter'  rwage`counter';
    regress earn`counter'  rearn`counter';
    regress  rtenure`counter' tenure`counter';
    *regress nohouse`counter' rnohouse`counter';
    *regress assets`counter' rassets`counter';
};
    local counter = `counter' + 1;
  };


  
  
  
sort hrscoh;
by hrscoh: sum rocc* occ*;
by hrscoh: sum rind* ind*;
by hrscoh: sum rhours* hours*;
by hrscoh: sum rlfpr*  lfpr*;
by hrscoh: sum rweeks* weeks*;
by hrscoh: sum rwage* wage*;
by hrscoh: sum rearn* earn*;
by hrscoh: sum tenure* rtenure*;
by hrscoh: sum rnohouse* nohouse*;
by hrscoh: sum rassets* assets*;


end;
compress;
testx9z;

*sum rhour* rweek*;


*sum rwage*;
*bomb;
*exit;


          
**********************************************************************************************************************;
*incomex.do variables;
**********************************************************************************************************************;
* the RAND coding is different from Eric's coding for some of the variables here;
*    ERIC                                                   RAND equivalent     ;
* ------------------------------------------------------------------------------;
*  LABY (labor income)                                    rLABY                 ;
*  SELFY+CAPY (Self-employment and capital income)        rCAPY (RAND does not break out self-employment and capital inc);
*  PENY (pensions and annuities and VA benefits)          rPENY (this does not include VA benefits)                      ;
*  SOCY (Social  Security and DI)                         rSOCY (this one is just Social Security);
*  OTHY (SSI and wlfare and unemployment)                 rSSDIY (SSI and DI)   ;
*                                                         rUNEMPY (unemployment and workers compensation);
*                                                         rOTHgovY (other government, such as veterans benefits, welfare, food stamps);
* 							                              rOTHincY  (inheritance, lump sum pension, alimony) ;
*  faminc (total household income)			  rfaminc (total household income, sum of everything above);
*-------------------------------------------------------------------------------;

program define testx9;
  local counter = 1;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;

    gen rLABY`counter'= r`counter'iearn; * laby=labor income (respondent);
if `counter'>1{;
    replace rLABY`counter2' = r`counter'iearn if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rLABY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

  
    gen _rLABY`counter' = s`counter'iearn ; * laby=labor income (spouse);
if `counter'>1{;
    replace _rLABY`counter2' = s`counter'iearn if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rLABY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

* SELFY: SELF EMPLOYMENT is covered under rcapy variable;
    
    gen rCAPY`counter'= h`counter'icap;* CAPY: CAPITAL INCOME;
if `counter'>1{;
    replace rCAPY`counter2' = h`counter'icap if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rCAPY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};
    gen rPENY`counter'= r`counter'ipena ; * PENY: PENSIONS;* COMPONENTS OF PENY ARE: PENY= peninc + anninc;
if `counter'>1{;
    replace rPENY`counter2' = r`counter'ipena if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rPENY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};

    gen _rPENY`counter'= s`counter'ipena ; * PENY: PENSIONS (spouse);* COMPONENTS OF PENY ARE: PENY= peninc + anninc;
if `counter'>1{;
    replace _rPENY`counter2' = s`counter'ipena if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rPENY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};



************************************************************************;
* ALL OF THE VARIABLES BELOW ARE VERY DIFFERENT FROM MY VARIABLES (ie, the ones coded in income.do)      ;
************************************************************************;

* social security ;

    gen rSOCY`counter'= r`counter'isret  ;* this is just Socialinc, whereas eric's SOCY = Socialinc +DIinc;
if `counter'>1{;
    replace rSOCY`counter2' = r`counter'isret  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rSOCY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};
 
    gen _rSOCY`counter'= s`counter'isret  ;* (spouse);
if `counter'>1{;
    replace _rSOCY`counter2' = s`counter'isret if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rSOCY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};

* ssi and di;

    gen rSSDIY`counter'= r`counter'issdi  ;
if `counter'>1{;
    replace rSSDIY`counter2' = r`counter'issdi  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rSSDIY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};
 
    gen _rSSDIY`counter'= s`counter'issdi  ; *(spouse);
if `counter'>1{;
    replace _rSSDIY`counter2' = s`counter'issdi  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rSSDIY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};

* unemployment and workers comp;

    gen rUNEMPY`counter'= r`counter'iunwc;
if `counter'>1{;
    replace rUNEMPY`counter2' = r`counter'iunwc if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rUNEMPY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};

    gen _rUNEMPY`counter'= s`counter'iunwc ; *(spouse);
if `counter'>1{;
    replace _rUNEMPY`counter2' = s`counter'iunwc if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rUNEMPY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};

* other government, such as veterans benefits, welfare, food stamps;

    gen rOTHgovY`counter'= r`counter'igxfr;
if `counter'>1{;
    replace rOTHgovY`counter2' = r`counter'igxfr if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rOTHgovY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};

    gen _rOTHgovY`counter'= s`counter'igxfr;
if `counter'>1{;
    replace _rOTHgovY`counter2' = s`counter'igxfr if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rOTHgovY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};


* rOTHincY  (inheritance, lump sum pension, alimony) ;

    gen rOTHincY`counter'= h`counter'iothr ; *OTHY(household level);
if `counter'>1{;
    replace rOTHincY`counter2' = h`counter'iothr if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rOTHincY`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3));
};


    local counter = `counter' + 1;
  };

end;
testx9;


*************************************************************************;
* eric's hrs coding is household level -- make rand coding the same      ;
*************************************************************************;

program define testx9s;
  local counter = 1;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;

replace _rLABY`counter'=0 if rLABY`counter'~=. & (_rLABY`counter'==. | _rLABY`counter'==.u);
replace _rPENY`counter'=0 if rPENY`counter'~=. & (_rPENY`counter'==. | _rPENY`counter'==.u ) ;
replace _rSSDIY`counter'=0 if rSSDIY`counter'~=. &  (_rSSDIY`counter'==. | _rSSDIY`counter'==.u);
replace _rSOCY`counter'=0 if rSOCY`counter'~=. & (_rSOCY`counter'==. | _rSOCY`counter'==.u);
replace _rUNEMPY`counter'=0 if rUNEMPY`counter'~=. & (_rUNEMPY`counter'==. | _rUNEMPY`counter'==.u);
replace _rOTHgovY`counter'=0 if rOTHgovY`counter'~=. & (_rOTHgovY`counter'==. | _rOTHgovY`counter'==.u);

        replace rLABY`counter'= rLABY`counter'+ _rLABY`counter';
	replace rCAPY`counter'= rCAPY`counter';
	replace rPENY`counter'= rPENY`counter'+_rPENY`counter';
	replace rSSDIY`counter'= rSSDIY`counter'+_rSSDIY`counter'; 
	replace rSOCY`counter'= rSOCY`counter'+ _rSOCY`counter';
	replace rUNEMPY`counter'= rUNEMPY`counter'+  _rUNEMPY`counter'; 
	replace rOTHgovY`counter'= rOTHgovY`counter'+_rOTHgovY`counter'; 
	* replace rOTHincY`counter'= rOTHincY`counter'+_rOTHincY`counter';  *household level in RAND;

	gen rfaminc`counter'= rLABY`counter'+ rCAPY`counter'+rPENY`counter'+rSSDIY`counter'+rSOCY`counter'+rUNEMPY`counter'+rOTHgovY`counter'+rOTHincY`counter';





if `counter'<=HRSwaves {;
gen capyj`counter'=selfy`counter'+capy`counter';

*****************************************;
*    regress  rLABY`counter' laby`counter';
*    regress  rCAPY`counter' capyj`counter';
*    regress  rPENY`counter' peny`counter';
*    regress  rSOCY`counter' socy`counter';
*****************************************;
};

    local counter = `counter' + 1;
};

sort hrscoh;
 
by hrscoh:    sum rLABY* laby*;
by hrscoh:    sum rCAPY* capyj*;
by hrscoh:    sum rPENY* peny*;
by hrscoh:    sum rSOCY* socy*;
by hrscoh:    sum rUNEMPY* rOTHgovY* rOTHincY*;


drop capyj*;
end;
testx9s;



*******************************************************************************************************************************;
*whetehr receiving DI or SSI  ;
**********************************************************************************************************************;
** here's what it looks like for wave 5                         ;
*  r5dstat:w5 'position |                                       ;
*  1=dk, 2=ssdi, 3=ssi' |      Freq.     Percent        Cum.    ;
*-----------------------+-----------------------------------    ;
*         0.no activity |     18,110       92.50       92.50    ;
*        1.applying ssi |         11        0.06       92.55    ;
*       2.receiving ssi |        240        1.23       93.78    ;
*      10.applying ssdi |         84        0.43       94.21    ;
*11.applying ssdi + ssi |          3        0.02       94.22    ;
*12.apply ssdi/recv ssi |          5        0.03       94.25    ;
*     20.receiving ssdi |        622        3.18       97.43    ;
*21.recv ssdi/apply ssi |          1        0.01       97.43    ;
*    22.recv ssdi + ssi |         75        0.38       97.81    ;
* 100.applying dk which |        156        0.80       98.61    ;
*200.receiving dk which |        272        1.39      100.00    ;
*-----------------------+-----------------------------------    ;
*                 Total |     19,579      100.00                ;



program define testx10ZZ;
  local counter = 1;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;
sum rd*;
    gen rdisabled`counter'= r`counter'dstat ; 
if `counter'>1{;
sum SSIi*;
    replace rdisabled`counter2' = r`counter'dstat  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rdisabled`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

  };

sort hrscoh;
by hrscoh: sum  rdisabled;

end;
*testx10ZZ;




*******************************************************************************************************************************;
*variables from healstat.do;
**********************************************************************************************************************;
program define testx10;
* Chris quoting from the RAND HRS Longitudinal File 2018 (V2) Documentation ;

*Adjustments, Improvements, and Corrections to the Data and Documentation: ;
*ADL, IADL, and Other Functional Limitations Variables;
*We updated variable labels for several ADL, IADL, and other Functional Limitations indicator variables to change from "Some;
*diff" to "Any diff" to more clearly match the question wording. We also renamed the following variables: RwADLA is now RwADL5A;
*and RwIADLZA is now RwIADL5A. Finally, we dropped several variables that users can easily calculate themselves: RwADLWA,;
*R1ADLWW, RwADLC, RwADLF, RwGROSSC, RwGROSSF, RwFINEC, RwFINEF, RwIADLA, R1IADLWW.;
* Chris: probably a better way and code location to do these renames;
rename r2adl5a r2adla;
rename r3adl5a r3adla;
rename r4adl5a r4adla;
rename r5adl5a r5adla;
rename r6adl5a r6adla;
rename r7adl5a r7adla;
rename r8adl5a r8adla;
rename r9adl5a r9adla;
rename r10adl5a r10adla;
rename r11adl5a r11adla;
rename r12adl5a r12adla;
rename r13adl5a r13adla;
rename r14adl5a r14adla;
* apparently the same for  SwADLA but I coudlnt find it in the doc;
rename s2adl5a s2adla;
rename s3adl5a s3adla;
rename s4adl5a s4adla;
rename s5adl5a s5adla;
rename s6adl5a s6adla;
rename s7adl5a s7adla;
rename s8adl5a s8adla;
rename s9adl5a s9adla;
rename s10adl5a s10adla;
rename s11adl5a s11adla;
rename s12adl5a s12adla;
rename s13adl5a s13adla;
rename s14adl5a s14adla;

gen r1adla=.;
gen s1adla=.;


  local counter = 1;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;

  
      gen rdisabled`counter'= r`counter'dstat ; *self-report of health (respondent);
if `counter'>1{;
    replace rdisabled`counter2' = r`counter'dstat  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rdisabled`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
  
  
  
    gen rheal`counter'= r`counter'shlt ; *self-report of health (respondent);
if `counter'>1{;
    replace rheal`counter2' = r`counter'shlt  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rheal`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen _rheal`counter'= s`counter'shlt ; *self-report of health  (spouse);
if `counter'>1{;
    replace _rheal`counter2' = s`counter'shlt  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rheal`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen rhealch`counter'=  r`counter'hltc3 ; *Health past (respondent);
	* Chris changed this to hltc3;
if `counter'>1{;
    replace rhealch`counter2' = r`counter'hltc3 if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rhealch`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen _rhealch`counter' = s`counter'hltc3; *Health past  (spouse);
	* Chris changed this to hltc3;
if `counter'>1{;
    replace _rhealch`counter2' = s`counter'hltc3 if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rhealch`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

    gen radl`counter'= r`counter'adla ; *Number of probelms with ADLs (respondent)--bathing, dressing, eating, getting in and out of bed, walking across the room, "some difficulty";
if `counter'>1{;
    replace radl`counter2' = r`counter'adla  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace radl`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

    gen _radl`counter'= s`counter'adla ; *Number of probelms with ADLs (respondent)--bathing, dressing, eating, getting in and out of bed, walking across the room, "some difficulty";
if `counter'>1{;
    replace _radl`counter2' = s`counter'adla  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _radl`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

if `counter'<=HRSwaves {;     
    sum rheal`counter' _rheal`counter' heal`counter';
    sum	rhealch`counter' _rhealch`counter' healch`counter';
    regress  rheal`counter' heal`counter';
    regress  _rheal`counter' heal`counter';
    regress  rhealch`counter' healch`counter';
    regress  _rhealch`counter' healch`counter';
*	regress radl`counter';
*	regress _radl`counter';
};

    local counter = `counter' + 1;
  };
* end while;
**N.B. there are two variables: aheal(1,2) and ahealch(1,2) for ahead waves one and two...RAND took the differences into consideration;
*when they imputed thus I did not feel it was necessary to include as they are already essentially included under heal(1,2) and healch (1,2);
*Also, ghealth another variable in healstat.do is "covered" by rands rwshlt variable which was also used above;
*pause HERE;
sum h1ahous;
sort hrscoh;
by hrscoh: sum  rheal* heal*;
by hrscoh: sum _rheal* heal*;
by hrscoh: sum rhealch* healch*;
by hrscoh: sum _rhealch* healch*;
by hrscoh: sum _radl* radl*;
*bomb;
end;

testx10;

*******************************************************************************************************************************;
*variables from mortality.do;
**********************************************************************************************************************;
program define testx11;
  local counter = 1;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;
    gen  rdead`counter'= r`counter'iwstat; *Mortality status (respondent);
if `counter'>1{;
    replace rdead`counter2' = r`counter'iwstat  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace rdead`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
    gen  _rdead`counter'= s`counter'iwstat; *mortality (spouse);
if `counter'>1{;
    replace _rdead`counter2' = s`counter'iwstat  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace _rdead`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

if `counter'<=HRSwaves {; 
   sum rdead`counter' _rdead`counter' dead`counter';
   regress  rdead`counter' dead`counter';
   regress  _rdead`counter' dead`counter';
};
  local counter = `counter' + 1;
  };
**N.B. The variables NAMONTH and NAYEAR are also in mortality.do however I don't know their significance;
*they are simply placed at the bottem of do file;
sum h1ahous;
sort hrscoh;
by hrscoh: sum rdead* dead*;
by hrscoh: sum _rdead* dead*;
end;

testx11;





program define testx11z;
drop temp;
  local counter = 1;
   while `counter' <= RANDwaves {;

gen temp=.;
replace temp=. if rdead`counter'==.;
replace temp=0 if rdead`counter'==1;
replace temp=0 if rdead`counter'==2;
replace temp=1 if rdead`counter'==3;
replace temp=0 if rdead`counter'==4;
replace temp=1 if rdead`counter'==5;
replace temp=1 if rdead`counter'==6;
replace temp=. if rdead`counter'==9;
replace rdead`counter'=temp;
drop temp;
gen temp=.;
replace temp=. if _rdead`counter'==.;
replace temp=0 if _rdead`counter'==1;
replace temp=0 if _rdead`counter'==2;
replace temp=1 if _rdead`counter'==3;
replace temp=0 if _rdead`counter'==4;
replace temp=1 if _rdead`counter'==5;
replace temp=1 if _rdead`counter'==6;
replace temp=. if _rdead`counter'==9;
replace _rdead`counter'=temp;
drop temp;

local counter = `counter' + 1;
};
end;
testx11z;



******************************************************************************************************************************;
* age Variables ;
**********************************************************************************************************************;
program define testx12;
  local counter = 1;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;



   gen rage`counter'=r`counter'agey_m;*Age (years) at Ivw MidMon;
if `counter'>1{;
    replace rage`counter2' = r`counter'agey_m  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rage`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
   
   gen _rage`counter'=s`counter'agey_m;*Age (years) at Ivw MidMon;
if `counter'>1{;
    replace _rage`counter2' = s`counter'agey_m  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  _rage`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
 
if `counter'<=HRSwaves {; 
    sum age`counter' rage`counter' ;


};    
    local counter = `counter' + 1;
};

sum h1ahous;
sort hrscoh;

by hrscoh: sum rage* age*;


* rage tends to be missing if the respondent is dead;
*rage tends to be 101 if the respondent is missing--use "potential" age;
* this no longer seems to happen in version F;
/*
replace rage1=. if rage1==101;
replace rage2=. if rage2==101;
replace rage3=. if rage3==101;
replace rage4=. if rage4==101;
replace rage5=. if rage5==101;
replace rage6=. if rage6==101;
*/
replace rage13=. if rage13>rage14 & rage14~=.;
replace rage12=. if rage12>rage13 & rage13~=.;
replace rage11=. if rage11>rage12 & rage12~=.;
replace rage10=. if rage10>rage11 & rage11~=.;
replace rage9=. if rage9>rage10 & rage10~=.;
replace rage8=. if rage8>rage9 & rage9~=.;
replace rage7=. if rage7>rage8 & rage8~=.;
replace rage6=. if rage6>rage7 & rage7~=.;
replace rage5=. if rage5>rage6 & rage6~=.;
replace rage4=. if rage4>rage5 & rage5~=.;
replace rage3=. if rage3>rage4 & rage4~=.;
replace rage2=. if (rage2>rage3 & rage3~=.)|(rage2>rage4 & rage4~=.);
replace rage1=. if rage1>rage2 & rage2~=.;

replace rage2=rage1+2 if (rage2==.|(rage2>rage1+3 & rage1~=.));
replace rage3=rage2+2 if (rage3==.|(rage3>rage2+3 & rage2~=.)) & (hrscoh~=11 & hrscoh~=12);
replace rage4=rage3+2 if (rage4==.|(rage4>rage3+3 & rage3~=.)) & (hrscoh~=11 & hrscoh~=12);
replace rage4=rage2+3 if (rage4==.|(rage4>rage3+3 & rage3~=.)) & (hrscoh==11|hrscoh==12);
replace rage5=rage4+2 if (rage5==.|(rage5>rage4+3 & rage4~=.));
replace rage6=rage5+2 if (rage6==.|(rage6>rage5+3 & rage5~=.));
replace rage7=rage6+2 if (rage7==.|(rage7>rage6+3 & rage6~=.));
replace rage8=rage7+2 if (rage8==.|(rage8>rage7+3 & rage7~=.));
replace rage9=rage8+2 if (rage9==.|(rage9>rage8+3 & rage8~=.));
replace rage10=rage9+2 if (rage10==.|(rage10>rage9+3 & rage9~=.));
replace rage11=rage10+2 if (rage11==.|(rage11>rage10+3 & rage10~=.));
replace rage12=rage11+2 if (rage12==.|(rage12>rage11+3 & rage11~=.));
replace rage13=rage12+2 if (rage13==.|(rage13>rage12+3 & rage12~=.));
replace rage14=rage13+2 if (rage14==.|(rage14>rage13+3 & rage13~=.));

replace rage13=rage14-2 if rage13==.;
replace rage12=rage13-2 if rage12==.;
replace rage11=rage12-2 if rage11==.;
replace rage10=rage11-2 if rage10==.;
replace rage9=rage10-2 if rage9==.;
replace rage8=rage9-2 if rage8==.;
replace rage7=rage8-2 if rage7==.;
replace rage6=rage7-2 if rage6==.;
replace rage5=rage6-2 if rage5==.;
replace rage4=rage5-2 if rage4==.;
replace rage2=rage4-3 if rage2==. & (hrscoh==11 | hrscoh==12);
replace rage3=rage4-2 if rage3==. & hrscoh~=11 & hrscoh~=12;
replace rage2=rage3-2 if rage2==. & hrscoh~=11 & hrscoh~=12;
replace rage1=rage2-2 if rage1==.;


* spouse's _rage seems to have the same quirks as rage;
/*replace _rage1=. if _rage1==101;
replace _rage2=. if _rage2==101;
replace _rage3=. if _rage3==101;
replace _rage4=. if _rage4==101;
replace _rage5=. if _rage5==101;
replace _rage6=. if _rage6==101;
*/
replace _rage13=. if _rage13>_rage14 & _rage14~=.;
replace _rage12=. if _rage12>_rage13 & _rage13~=.;
replace _rage11=. if _rage11>_rage12 & _rage12~=.;
replace _rage10=. if _rage10>_rage11 & _rage11~=.;
replace _rage9=. if _rage9>_rage10 & _rage10~=.;
replace _rage8=. if _rage8>_rage9 & _rage9~=.;
replace _rage7=. if _rage7>_rage8 & _rage8~=.;
replace _rage6=. if _rage6>_rage7 & _rage7~=.;
replace _rage5=. if _rage5>_rage6 & _rage6~=.;
replace _rage4=. if _rage4>_rage5 & _rage5~=.;
replace _rage3=. if _rage3>_rage4 & _rage4~=.;
replace _rage2=. if (_rage2>_rage3 & _rage3~=.)|(_rage2>_rage4 & _rage4~=.);
replace _rage1=. if _rage1>_rage2 & _rage2~=.;

replace _rage2=_rage1+2 if (_rage2==.|(_rage2>_rage1+3 & _rage1~=.));
replace _rage3=_rage2+2 if (_rage3==.|(_rage3>_rage2+3 & _rage2~=.)) & (hrscoh~=11 & hrscoh~=12);
replace _rage4=_rage3+2 if (_rage4==.|(_rage4>_rage3+3 & _rage3~=.)) & (hrscoh~=11 & hrscoh~=12);
replace _rage4=_rage2+3 if (_rage4==.|(_rage4>_rage3+3 & _rage3~=.)) & (hrscoh==11|hrscoh==12);
replace _rage5=_rage4+2 if (_rage5==.|(_rage5>_rage4+3 & _rage4~=.));
replace _rage6=_rage5+2 if (_rage6==.|(_rage6>_rage5+3 & _rage5~=.));
replace _rage7=_rage6+2 if (_rage7==.|(_rage7>_rage6+3 & _rage6~=.));
replace _rage8=_rage7+2 if (_rage8==.|(_rage8>_rage7+3 & _rage7~=.));
replace _rage9=_rage8+2 if (_rage9==.|(_rage9>_rage8+3 & _rage8~=.));
replace _rage10=_rage9+2 if (_rage10==.|(_rage10>_rage9+3 & _rage9~=.));
replace _rage11=_rage10+2 if (_rage11==.|(_rage11>_rage10+3 & _rage10~=.));
replace _rage12=_rage11+2 if (_rage12==.|(_rage12>_rage11+3 & _rage11~=.));
replace _rage13=_rage12+2 if (_rage13==.|(_rage13>_rage12+3 & _rage12~=.));
replace _rage14=_rage13+2 if (_rage14==.|(_rage14>_rage13+3 & _rage13~=.));

replace _rage13=_rage14-2 if _rage13==.;
replace _rage12=_rage13-2 if _rage12==.;
replace _rage11=_rage12-2 if _rage11==.;
replace _rage10=_rage11-2 if _rage10==.;
replace _rage9=_rage10-2 if _rage9==.;
replace _rage8=_rage9-2 if _rage8==.;
replace _rage7=_rage8-2 if _rage7==.;
replace _rage6=_rage7-2 if _rage6==.;
replace _rage5=_rage6-2 if _rage5==.;
replace _rage4=_rage5-2 if _rage4==.;
replace _rage2=_rage4-3 if _rage2==. & (hrscoh==11|hrscoh==12);
replace _rage3=_rage4-2 if _rage3==. & (hrscoh~=11 & hrscoh~=12);
replace _rage2=_rage3-2 if _rage2==. & (hrscoh~=11 & hrscoh~=12);
replace _rage1=_rage2-2 if _rage1==.;


by hrscoh: sum rage* age*;


end;
testx12;

*end;

compress;

**********************************************************************************************************************;
*N.B. RAND does not have a variable synonymous to our reason variable;
************************************************f*************************************************************************;
*variables from healutil.do;*wave 1 variables =annual all other are for every 2 years;
gen rtc1=r1totmd;
gen rhosp1=r1hspnit;
gen rnursing1=r1nrsnit;
gen rdrtimes1=r1doctim;
program define testx13;
  local counter = 2;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;

gen rtc`counter'= (r`counter'totmd)/2;*total medical expenditures;
if `counter'>2{;
    replace rtc`counter2' = (r`counter'totmd)/2 if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rtc`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

gen rhosp`counter'= (r`counter'hspnit)/2;*hospital nights previous year;
if `counter'>2{;
    replace rhosp`counter2' = (r`counter'hspnit)/2 if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rhosp`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

gen rnursing`counter'= (r`counter'nrsnit)/2;*nursing home nights previous year;
if `counter'>2{;
    replace rnursing`counter2' = (r`counter'nrsnit)/2  if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rnursing`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

gen rdrtimes`counter'= (r`counter'doctim)/2;
if `counter'>2{;
    replace rdrtimes`counter2' = (r`counter'doctim)/2 if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rdrtimes`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};
local counter = `counter' + 1;
};
end;
testx13;
*************************************************************************************************************;
*variables from healutil.do;
*program define testx14;
  *local counter = 1;
   *while `counter' <= RANDwaves {;
  *local counter2 = `counter'-1;

*if `counter'<=HRSwaves {; 
    *regress  tc`counter' rtc`counter';
    *regress  hosp`counter' rhosp`counter';
    *regress  nursing`counter' rnursing`counter';
    *regress  drtimes`counter' rdrtimes`counter';

*};

*local counter = `counter' + 1;
*};
*sum h1ahous;
*sort hrscoh;
*by hrscoh: sum tc* rtc*;
*by hrscoh: sum hosp* rhosp*;
*by hrscoh: sum nursing* rnursing*;
*by hrscoh: sum drtimes* rdrtimes*;
*end;
*testx14;



**************************************************************************************************************;
*variables from healutil.do waves 2-6;
program define testx15;
  local counter = 2;
   while `counter' <= RANDwaves {;
  local counter2 = `counter'-1;

gen rdruguse`counter'= r`counter'drugs;
if `counter'>2{;
    replace rdruguse`counter2' = r`counter'drugs if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  rdruguse`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

gen routsurg`counter'= r`counter'outpt;
if `counter'>2{;
    replace routsurg`counter2' = r`counter'outpt if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace  routsurg`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

gen rdentist`counter'= r`counter'dentst;
if `counter'>2{;
    replace  rdentist`counter2' = r`counter'dentst if ((hrscoh==11|hrscoh==12) & (`counter'<4 & `counter'>1)) ;
    replace   rdentist`counter'=. if ((hrscoh==11|hrscoh==12) & (`counter'==3)) ;
};

if `counter'<=HRSwaves {; 
************************************************************;
*    regress  outsurg`counter' routsurg`counter';
*    regress  dentist`counter' rdentist`counter';
************************************************************;
};    
    local counter = `counter' + 1;
};

gen rdruguse1=.;
gen routsurg1=.;
gen rdentist1=.;

sort hrscoh;
by hrscoh: sum drugc* rdruguse*;
by hrscoh: sum outsurg* routsurg*;
by hrscoh: sum dentist* rdentist*;
end;
testx15;
****************************************************************************************************************************;
   rename rabyear rbirthyr; * Birth Year (Respondent); 
   rename rabmonth rbirthm; * Birth Month (Respondent); 
   rename ragender rtmale; * Gender (Respondent);
   
   gen rblack = 0; * Generate Race Flag; 
   replace rblack = 1 if raracem == 2; 
   replace rblack = . if raracem == .; 

   gen rhispan = 0; * Generate Hispanic Flag;
   replace rhispan = 1 if rahispan == 1;
   replace rhispan = . if rahispan == .;

    
   gen rmale = 0; * Generate Gender Flag; 
   replace rmale = 1 if rtmale == 1; 
   replace rmale = . if rtmale == .; 
   
   
****************************************************************************************************;
* clean up the age variables ***********************************************************************;
****************************************************************************************************;

* first use spouses _rage to infer rage;
sort HHID PN;
replace rage1=_rage1[_n-1] if HHID==HHID[_n-1] & rage1==.;
replace rage2=_rage2[_n-1] if HHID==HHID[_n-1] & rage2==.;
replace rage3=_rage3[_n-1] if HHID==HHID[_n-1] & rage3==.;
replace rage4=_rage4[_n-1] if HHID==HHID[_n-1] & rage4==.;
replace rage5=_rage5[_n-1] if HHID==HHID[_n-1] & rage5==.;
replace rage6=_rage6[_n-1] if HHID==HHID[_n-1] & rage6==.;
replace rage7=_rage7[_n-1] if HHID==HHID[_n-1] & rage7==.;
replace rage8=_rage8[_n-1] if HHID==HHID[_n-1] & rage8==.;
replace rage9=_rage9[_n-1] if HHID==HHID[_n-1] & rage9==.;
replace rage10=_rage10[_n-1] if HHID==HHID[_n-1] & rage10==.;
replace rage11=_rage11[_n-1] if HHID==HHID[_n-1] & rage11==.;
replace rage12=_rage12[_n-1] if HHID==HHID[_n-1] & rage12==.;
replace rage13=_rage13[_n-1] if HHID==HHID[_n-1] & rage13==.;
replace rage14=_rage14[_n-1] if HHID==HHID[_n-1] & rage14==.;

replace rage1=_age1[_n-1] if HHID==HHID[_n-1] & rage1==.;
replace rage2=_age2[_n-1] if HHID==HHID[_n-1] & rage2==.;
replace rage3=_age3[_n-1] if HHID==HHID[_n-1] & rage3==.;
replace rage4=_age4[_n-1] if HHID==HHID[_n-1] & rage4==.;
replace rage5=_age5[_n-1] if HHID==HHID[_n-1] & rage5==.;
replace rage6=_age6[_n-1] if HHID==HHID[_n-1] & rage6==.;
replace rage7=_age7[_n-1] if HHID==HHID[_n-1] & rage7==.;
replace rage8=_age8[_n-1] if HHID==HHID[_n-1] & rage8==.;
replace rage9=_age9[_n-1] if HHID==HHID[_n-1] & rage9==.;
replace rage10=_age10[_n-1] if HHID==HHID[_n-1] & rage10==.;
replace rage11=_age11[_n-1] if HHID==HHID[_n-1] & rage11==.;
replace rage12=_age12[_n-1] if HHID==HHID[_n-1] & rage12==.;
replace rage13=_age13[_n-1] if HHID==HHID[_n-1] & rage13==.;
replace rage14=_age14[_n-1] if HHID==HHID[_n-1] & rage14==.;

*gen omPN=1-PN;
sort HHID omPN;
drop omPN;
replace rage1=_rage1[_n-1] if HHID==HHID[_n-1] & rage1==.;
replace rage2=_rage2[_n-1] if HHID==HHID[_n-1] & rage2==.;
replace rage3=_rage3[_n-1] if HHID==HHID[_n-1] & rage3==.;
replace rage4=_rage4[_n-1] if HHID==HHID[_n-1] & rage4==.;
replace rage5=_rage5[_n-1] if HHID==HHID[_n-1] & rage5==.;
replace rage6=_rage6[_n-1] if HHID==HHID[_n-1] & rage6==.;
replace rage7=_rage7[_n-1] if HHID==HHID[_n-1] & rage7==.;
replace rage8=_rage8[_n-1] if HHID==HHID[_n-1] & rage8==.;
replace rage9=_rage9[_n-1] if HHID==HHID[_n-1] & rage9==.;
replace rage10=_rage10[_n-1] if HHID==HHID[_n-1] & rage10==.;
replace rage11=_rage11[_n-1] if HHID==HHID[_n-1] & rage11==.;
replace rage12=_rage12[_n-1] if HHID==HHID[_n-1] & rage12==.;
replace rage13=_rage13[_n-1] if HHID==HHID[_n-1] & rage13==.;
replace rage14=_rage14[_n-1] if HHID==HHID[_n-1] & rage14==.;

replace rage1=_age1[_n-1] if HHID==HHID[_n-1] & rage1==.;
replace rage2=_age2[_n-1] if HHID==HHID[_n-1] & rage2==.;
replace rage3=_age3[_n-1] if HHID==HHID[_n-1] & rage3==.;
replace rage4=_age4[_n-1] if HHID==HHID[_n-1] & rage4==.;
replace rage5=_age5[_n-1] if HHID==HHID[_n-1] & rage5==.;
replace rage6=_age6[_n-1] if HHID==HHID[_n-1] & rage6==.;
replace rage7=_age7[_n-1] if HHID==HHID[_n-1] & rage7==.;
replace rage8=_age8[_n-1] if HHID==HHID[_n-1] & rage8==.;
replace rage9=_age9[_n-1] if HHID==HHID[_n-1] & rage9==.;
replace rage10=_age10[_n-1] if HHID==HHID[_n-1] & rage10==.;
replace rage11=_age11[_n-1] if HHID==HHID[_n-1] & rage11==.;
replace rage12=_age12[_n-1] if HHID==HHID[_n-1] & rage12==.;
replace rage13=_age13[_n-1] if HHID==HHID[_n-1] & rage13==.;
replace rage14=_age14[_n-1] if HHID==HHID[_n-1] & rage14==.;

* next, use birthyear and wave;
replace rage1=1993-birthyr if rage1==. & (hrscoh==11|hrscoh==12);
replace rage2=1995-birthyr if rage2==. & (hrscoh==11|hrscoh==12);

replace rage1=1992-birthyr if rage1==. & hrscoh==1;
replace rage2=1994-birthyr if rage2==. & hrscoh==1;
replace rage3=1996-birthyr if rage3==. & hrscoh==1;

replace rage4=1998-birthyr if rage4==.;
replace rage5=2000-birthyr if rage5==.;
replace rage6=2002-birthyr if rage6==.;
replace rage7=2004-birthyr if rage7==.;
replace rage8=2006-birthyr if rage8==.;
replace rage9=2008-birthyr if rage9==.;
replace rage10=2010-birthyr if rage10==.;
replace rage11=2012-birthyr if rage11==.;
replace rage12=2014-birthyr if rage12==.;  
replace rage13=2016-birthyr if rage13==.;  
replace rage14=2018-birthyr if rage14==.;  

* use previous age to infer true age;
replace rage2=rage1+2 if rage2==.;
replace rage3=rage2+2 if rage3==. & hrscoh==1;
replace rage4=rage3+2 if rage4==. & hrscoh==1;
replace rage4=rage2+3 if rage4==. & (hrscoh==11|hrscoh==12);
replace rage5=rage4+2 if rage5==.;
replace rage6=rage5+2 if rage6==.;
replace rage7=rage6+2 if rage7==.;
replace rage8=rage7+2 if rage8==.;
replace rage9=rage8+2 if rage9==.;
replace rage10=rage9+2 if rage10==.;
replace rage11=rage10+2 if rage11==.;
replace rage12=rage11+2 if rage12==.;
replace rage13=rage12+2 if rage13==.;
replace rage14=rage13+2 if rage14==.;

* use future age to infer age;
replace rage13=rage14-2 if rage13==.;
replace rage12=rage13-2 if rage12==.;
replace rage11=rage12-2 if rage11==.;
replace rage10=rage11-2 if rage10==.;
replace rage9=rage10-2 if rage9==.;
replace rage8=rage9-2 if rage8==.;
replace rage7=rage8-2 if rage7==.;
replace rage6=rage7-2 if rage6==.;
replace rage5=rage6-2 if rage5==.;
replace rage4=rage5-2 if rage4==.;
replace rage2=rage3-3 if rage2==. & (hrscoh==11|hrscoh==12);
replace rage2=rage3-2 if rage2==. & hrscoh==1;
replace rage2=rage3-2 if rage2==. & hrscoh==1;
replace rage1=rage2-2 if rage1==.;


replace age1=rage1 if age1==.;
replace age2=rage2 if age2==.;
replace age3=rage3 if age3==.;
replace age4=rage4 if age4==.;
replace age5=rage5 if age5==.;
replace age6=rage6 if age6==.;
replace age7=rage7 if age7==.;
replace age8=rage8 if age8==.;
replace age9=rage9 if age9==.;
replace age10=rage10 if age10==.;
replace age11=rage11 if age11==.;
replace age12=rage12 if age12==.;
replace age13=rage13 if age13==.;
replace age14=rage14 if age14==.;

replace birthyr=2000-age5 if birthyr==.;
replace birthyr=2002-age6 if birthyr==.;
replace birthyr=2004-age7 if birthyr==.;
replace birthyr=2006-age8 if birthyr==.;
replace birthyr=2008-age9 if birthyr==.;
replace birthyr=2010-age10 if birthyr==.;
replace birthyr=2012-age11 if birthyr==.;
replace birthyr=2014-age12 if birthyr==.;
replace birthyr=2016-age13 if birthyr==.;
replace birthyr=2018-age14 if birthyr==.;

compress;
*gen earnlast12=.;
*gen earnprev12=.;
*gen wagelast12=.;
*gen wageprev12=.;
*gen pennage12=.;
*gen peneage12=.;
*gen tenurelast12=.;
*gen tenureprev12=.;
*gen pentypeDCcurr12=.;
*gen pentypeDClast12=.;
*gen pentypeDCprev12=.;
*gen penwDCcurr12=.;
*gen penwDClast12=.;
*gen penwDCprev12=.;
*gen penwDC12=.;
*gen pentypeDBcurr12=.;
*gen pentypeDBlast12=.;
*gen pentypeDBprev12=.;

save "`saved'randdata1", replace;
*drop _all;
program drop _all;
log close ;
